/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.OfferingPromotion;
import software.amazon.awssdk.services.devicefarm.model.OfferingPromotionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOfferingPromotionsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListOfferingPromotionsResponse> {
    private final List<OfferingPromotion> offeringPromotions;
    private final String nextToken;

    private ListOfferingPromotionsResponse(BuilderImpl builder) {
        super(builder);
        this.offeringPromotions = builder.offeringPromotions;
        this.nextToken = builder.nextToken;
    }

    public List<OfferingPromotion> offeringPromotions() {
        return this.offeringPromotions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringPromotions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOfferingPromotionsResponse)) {
            return false;
        }
        ListOfferingPromotionsResponse other = (ListOfferingPromotionsResponse)((Object)obj);
        return Objects.equals(this.offeringPromotions(), other.offeringPromotions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.offeringPromotions() != null) {
            sb.append("OfferingPromotions: ").append(this.offeringPromotions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offeringPromotions": {
                return Optional.of(clazz.cast(this.offeringPromotions()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<OfferingPromotion> offeringPromotions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOfferingPromotionsResponse model) {
            this.offeringPromotions(model.offeringPromotions);
            this.nextToken(model.nextToken);
        }

        public final Collection<OfferingPromotion.Builder> getOfferingPromotions() {
            return this.offeringPromotions != null ? (Collection)this.offeringPromotions.stream().map(OfferingPromotion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder offeringPromotions(Collection<OfferingPromotion> offeringPromotions) {
            this.offeringPromotions = OfferingPromotionsCopier.copy(offeringPromotions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringPromotions(OfferingPromotion ... offeringPromotions) {
            this.offeringPromotions(Arrays.asList(offeringPromotions));
            return this;
        }

        public final void setOfferingPromotions(Collection<OfferingPromotion.BuilderImpl> offeringPromotions) {
            this.offeringPromotions = OfferingPromotionsCopier.copyFromBuilder(offeringPromotions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOfferingPromotionsResponse build() {
            return new ListOfferingPromotionsResponse(this);
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    CopyableBuilder<Builder, ListOfferingPromotionsResponse> {
        public Builder offeringPromotions(Collection<OfferingPromotion> var1);

        public Builder offeringPromotions(OfferingPromotion ... var1);

        public Builder nextToken(String var1);
    }
}

