/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest;
import software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse;
import software.amazon.awssdk.services.devicefarm.model.OfferingStatus;

public final class GetOfferingStatusPaginator
implements SdkIterable<GetOfferingStatusResponse> {
    private final DeviceFarmClient client;
    private final GetOfferingStatusRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetOfferingStatusPaginator(DeviceFarmClient client, GetOfferingStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetOfferingStatusResponseFetcher();
    }

    public Iterator<GetOfferingStatusResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Map.Entry<String, OfferingStatus>> current() {
        Function<GetOfferingStatusResponse, Iterator> getIterator = response -> response != null ? response.current().entrySet().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public SdkIterable<Map.Entry<String, OfferingStatus>> nextPeriod() {
        Function<GetOfferingStatusResponse, Iterator> getIterator = response -> response != null ? response.nextPeriod().entrySet().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class GetOfferingStatusResponseFetcher
    implements NextPageFetcher<GetOfferingStatusResponse> {
        private GetOfferingStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetOfferingStatusResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetOfferingStatusResponse nextPage(GetOfferingStatusResponse previousPage) {
            if (previousPage == null) {
                return GetOfferingStatusPaginator.this.client.getOfferingStatus(GetOfferingStatusPaginator.this.firstRequest);
            }
            return GetOfferingStatusPaginator.this.client.getOfferingStatus((GetOfferingStatusRequest)((Object)GetOfferingStatusPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

