/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse;
import software.amazon.awssdk.services.devicefarm.model.OfferingTransaction;

public final class ListOfferingTransactionsPaginator
implements SdkIterable<ListOfferingTransactionsResponse> {
    private final DeviceFarmClient client;
    private final ListOfferingTransactionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListOfferingTransactionsPaginator(DeviceFarmClient client, ListOfferingTransactionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOfferingTransactionsResponseFetcher();
    }

    public Iterator<ListOfferingTransactionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<OfferingTransaction> offeringTransactions() {
        Function<ListOfferingTransactionsResponse, Iterator> getIterator = response -> response != null ? response.offeringTransactions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListOfferingTransactionsResponseFetcher
    implements NextPageFetcher<ListOfferingTransactionsResponse> {
        private ListOfferingTransactionsResponseFetcher() {
        }

        public boolean hasNextPage(ListOfferingTransactionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListOfferingTransactionsResponse nextPage(ListOfferingTransactionsResponse previousPage) {
            if (previousPage == null) {
                return ListOfferingTransactionsPaginator.this.client.listOfferingTransactions(ListOfferingTransactionsPaginator.this.firstRequest);
            }
            return ListOfferingTransactionsPaginator.this.client.listOfferingTransactions((ListOfferingTransactionsRequest)((Object)ListOfferingTransactionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

