/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a create project request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateProjectResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<CreateProjectResponse.Builder, CreateProjectResponse> {
    private final Project project;

    private CreateProjectResponse(BuilderImpl builder) {
        super(builder);
        this.project = builder.project;
    }

    /**
     * <p>
     * The newly created project.
     * </p>
     * 
     * @return The newly created project.
     */
    public Project project() {
        return project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(project());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectResponse)) {
            return false;
        }
        CreateProjectResponse other = (CreateProjectResponse) obj;
        return Objects.equals(project(), other.project());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateProjectResponse").add("Project", project()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "project":
            return Optional.of(clazz.cast(project()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmResponse.Builder, CopyableBuilder<Builder, CreateProjectResponse> {
        /**
         * <p>
         * The newly created project.
         * </p>
         * 
         * @param project
         *        The newly created project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(Project project);

        /**
         * <p>
         * The newly created project.
         * </p>
         * This is a convenience that creates an instance of the {@link Project.Builder} avoiding the need to create one
         * manually via {@link Project#builder()}.
         *
         * When the {@link Consumer} completes, {@link Project.Builder#build()} is called immediately and its result is
         * passed to {@link #project(Project)}.
         * 
         * @param project
         *        a consumer that will call methods on {@link Project.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #project(Project)
         */
        default Builder project(Consumer<Project.Builder> project) {
            return project(Project.builder().apply(project).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private Project project;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectResponse model) {
            project(model.project);
        }

        public final Project.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        @Override
        public final Builder project(Project project) {
            this.project = project;
            return this;
        }

        public final void setProject(Project.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public CreateProjectResponse build() {
            return new CreateProjectResponse(this);
        }
    }
}
