/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.ExecutionConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents configuration information about a test run, such as the execution timeout (in minutes).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ExecutionConfiguration implements StructuredPojo,
        ToCopyableBuilder<ExecutionConfiguration.Builder, ExecutionConfiguration> {
    private final Integer jobTimeoutMinutes;

    private final Boolean accountsCleanup;

    private final Boolean appPackagesCleanup;

    private ExecutionConfiguration(BuilderImpl builder) {
        this.jobTimeoutMinutes = builder.jobTimeoutMinutes;
        this.accountsCleanup = builder.accountsCleanup;
        this.appPackagesCleanup = builder.appPackagesCleanup;
    }

    /**
     * <p>
     * The number of minutes a test run will execute before it times out.
     * </p>
     * 
     * @return The number of minutes a test run will execute before it times out.
     */
    public Integer jobTimeoutMinutes() {
        return jobTimeoutMinutes;
    }

    /**
     * <p>
     * True if account cleanup is enabled at the beginning of the test; otherwise, false.
     * </p>
     * 
     * @return True if account cleanup is enabled at the beginning of the test; otherwise, false.
     */
    public Boolean accountsCleanup() {
        return accountsCleanup;
    }

    /**
     * <p>
     * True if app package cleanup is enabled at the beginning of the test; otherwise, false.
     * </p>
     * 
     * @return True if app package cleanup is enabled at the beginning of the test; otherwise, false.
     */
    public Boolean appPackagesCleanup() {
        return appPackagesCleanup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(accountsCleanup());
        hashCode = 31 * hashCode + Objects.hashCode(appPackagesCleanup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionConfiguration)) {
            return false;
        }
        ExecutionConfiguration other = (ExecutionConfiguration) obj;
        return Objects.equals(jobTimeoutMinutes(), other.jobTimeoutMinutes())
                && Objects.equals(accountsCleanup(), other.accountsCleanup())
                && Objects.equals(appPackagesCleanup(), other.appPackagesCleanup());
    }

    @Override
    public String toString() {
        return ToString.builder("ExecutionConfiguration").add("JobTimeoutMinutes", jobTimeoutMinutes())
                .add("AccountsCleanup", accountsCleanup()).add("AppPackagesCleanup", appPackagesCleanup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobTimeoutMinutes":
            return Optional.of(clazz.cast(jobTimeoutMinutes()));
        case "accountsCleanup":
            return Optional.of(clazz.cast(accountsCleanup()));
        case "appPackagesCleanup":
            return Optional.of(clazz.cast(appPackagesCleanup()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExecutionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ExecutionConfiguration> {
        /**
         * <p>
         * The number of minutes a test run will execute before it times out.
         * </p>
         * 
         * @param jobTimeoutMinutes
         *        The number of minutes a test run will execute before it times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTimeoutMinutes(Integer jobTimeoutMinutes);

        /**
         * <p>
         * True if account cleanup is enabled at the beginning of the test; otherwise, false.
         * </p>
         * 
         * @param accountsCleanup
         *        True if account cleanup is enabled at the beginning of the test; otherwise, false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountsCleanup(Boolean accountsCleanup);

        /**
         * <p>
         * True if app package cleanup is enabled at the beginning of the test; otherwise, false.
         * </p>
         * 
         * @param appPackagesCleanup
         *        True if app package cleanup is enabled at the beginning of the test; otherwise, false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appPackagesCleanup(Boolean appPackagesCleanup);
    }

    static final class BuilderImpl implements Builder {
        private Integer jobTimeoutMinutes;

        private Boolean accountsCleanup;

        private Boolean appPackagesCleanup;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionConfiguration model) {
            jobTimeoutMinutes(model.jobTimeoutMinutes);
            accountsCleanup(model.accountsCleanup);
            appPackagesCleanup(model.appPackagesCleanup);
        }

        public final Integer getJobTimeoutMinutes() {
            return jobTimeoutMinutes;
        }

        @Override
        public final Builder jobTimeoutMinutes(Integer jobTimeoutMinutes) {
            this.jobTimeoutMinutes = jobTimeoutMinutes;
            return this;
        }

        public final void setJobTimeoutMinutes(Integer jobTimeoutMinutes) {
            this.jobTimeoutMinutes = jobTimeoutMinutes;
        }

        public final Boolean getAccountsCleanup() {
            return accountsCleanup;
        }

        @Override
        public final Builder accountsCleanup(Boolean accountsCleanup) {
            this.accountsCleanup = accountsCleanup;
            return this;
        }

        public final void setAccountsCleanup(Boolean accountsCleanup) {
            this.accountsCleanup = accountsCleanup;
        }

        public final Boolean getAppPackagesCleanup() {
            return appPackagesCleanup;
        }

        @Override
        public final Builder appPackagesCleanup(Boolean appPackagesCleanup) {
            this.appPackagesCleanup = appPackagesCleanup;
            return this;
        }

        public final void setAppPackagesCleanup(Boolean appPackagesCleanup) {
            this.appPackagesCleanup = appPackagesCleanup;
        }

        @Override
        public ExecutionConfiguration build() {
            return new ExecutionConfiguration(this);
        }
    }
}
