/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.IncompatibilityMessageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about incompatibility.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IncompatibilityMessage implements StructuredPojo,
        ToCopyableBuilder<IncompatibilityMessage.Builder, IncompatibilityMessage> {
    private final String message;

    private final String type;

    private IncompatibilityMessage(BuilderImpl builder) {
        this.message = builder.message;
        this.type = builder.type;
    }

    /**
     * <p>
     * A message about the incompatibility.
     * </p>
     * 
     * @return A message about the incompatibility.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The type of incompatibility.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ARN: The ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * FORM_FACTOR: The form factor (for example, phone or tablet).
     * </p>
     * </li>
     * <li>
     * <p>
     * MANUFACTURER: The manufacturer.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM: The platform (for example, Android or iOS).
     * </p>
     * </li>
     * <li>
     * <p>
     * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_VERSION: The Appium version for the test.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeviceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of incompatibility.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ARN: The ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FORM_FACTOR: The form factor (for example, phone or tablet).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MANUFACTURER: The manufacturer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM: The platform (for example, Android or iOS).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_VERSION: The Appium version for the test.
     *         </p>
     *         </li>
     * @see DeviceAttribute
     */
    public DeviceAttribute type() {
        return DeviceAttribute.fromValue(type);
    }

    /**
     * <p>
     * The type of incompatibility.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ARN: The ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * FORM_FACTOR: The form factor (for example, phone or tablet).
     * </p>
     * </li>
     * <li>
     * <p>
     * MANUFACTURER: The manufacturer.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM: The platform (for example, Android or iOS).
     * </p>
     * </li>
     * <li>
     * <p>
     * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_VERSION: The Appium version for the test.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeviceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of incompatibility.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ARN: The ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FORM_FACTOR: The form factor (for example, phone or tablet).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MANUFACTURER: The manufacturer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM: The platform (for example, Android or iOS).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_VERSION: The Appium version for the test.
     *         </p>
     *         </li>
     * @see DeviceAttribute
     */
    public String typeString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncompatibilityMessage)) {
            return false;
        }
        IncompatibilityMessage other = (IncompatibilityMessage) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(typeString(), other.typeString());
    }

    @Override
    public String toString() {
        return ToString.builder("IncompatibilityMessage").add("Message", message()).add("Type", typeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "message":
            return Optional.of(clazz.cast(message()));
        case "type":
            return Optional.of(clazz.cast(typeString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IncompatibilityMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, IncompatibilityMessage> {
        /**
         * <p>
         * A message about the incompatibility.
         * </p>
         * 
         * @param message
         *        A message about the incompatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The type of incompatibility.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ARN: The ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORM_FACTOR: The form factor (for example, phone or tablet).
         * </p>
         * </li>
         * <li>
         * <p>
         * MANUFACTURER: The manufacturer.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM: The platform (for example, Android or iOS).
         * </p>
         * </li>
         * <li>
         * <p>
         * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_VERSION: The Appium version for the test.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of incompatibility.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ARN: The ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORM_FACTOR: The form factor (for example, phone or tablet).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MANUFACTURER: The manufacturer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM: The platform (for example, Android or iOS).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_VERSION: The Appium version for the test.
         *        </p>
         *        </li>
         * @see DeviceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAttribute
         */
        Builder type(String type);

        /**
         * <p>
         * The type of incompatibility.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ARN: The ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORM_FACTOR: The form factor (for example, phone or tablet).
         * </p>
         * </li>
         * <li>
         * <p>
         * MANUFACTURER: The manufacturer.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM: The platform (for example, Android or iOS).
         * </p>
         * </li>
         * <li>
         * <p>
         * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_VERSION: The Appium version for the test.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of incompatibility.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ARN: The ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORM_FACTOR: The form factor (for example, phone or tablet).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MANUFACTURER: The manufacturer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM: The platform (for example, Android or iOS).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_VERSION: The Appium version for the test.
         *        </p>
         *        </li>
         * @see DeviceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAttribute
         */
        Builder type(DeviceAttribute type);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(IncompatibilityMessage model) {
            message(model.message);
            type(model.type);
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DeviceAttribute type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public IncompatibilityMessage build() {
            return new IncompatibilityMessage(this);
        }
    }
}
