/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request for a purchase offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PurchaseOfferingRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<PurchaseOfferingRequest.Builder, PurchaseOfferingRequest> {
    private final String offeringId;

    private final Integer quantity;

    private final String offeringPromotionId;

    private PurchaseOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.offeringId = builder.offeringId;
        this.quantity = builder.quantity;
        this.offeringPromotionId = builder.offeringPromotionId;
    }

    /**
     * <p>
     * The ID of the offering.
     * </p>
     * 
     * @return The ID of the offering.
     */
    public String offeringId() {
        return offeringId;
    }

    /**
     * <p>
     * The number of device slots you wish to purchase in an offering request.
     * </p>
     * 
     * @return The number of device slots you wish to purchase in an offering request.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * The ID of the offering promotion to be applied to the purchase.
     * </p>
     * 
     * @return The ID of the offering promotion to be applied to the purchase.
     */
    public String offeringPromotionId() {
        return offeringPromotionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(offeringPromotionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseOfferingRequest)) {
            return false;
        }
        PurchaseOfferingRequest other = (PurchaseOfferingRequest) obj;
        return Objects.equals(offeringId(), other.offeringId()) && Objects.equals(quantity(), other.quantity())
                && Objects.equals(offeringPromotionId(), other.offeringPromotionId());
    }

    @Override
    public String toString() {
        return ToString.builder("PurchaseOfferingRequest").add("OfferingId", offeringId()).add("Quantity", quantity())
                .add("OfferingPromotionId", offeringPromotionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringId":
            return Optional.of(clazz.cast(offeringId()));
        case "quantity":
            return Optional.of(clazz.cast(quantity()));
        case "offeringPromotionId":
            return Optional.of(clazz.cast(offeringPromotionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmRequest.Builder, CopyableBuilder<Builder, PurchaseOfferingRequest> {
        /**
         * <p>
         * The ID of the offering.
         * </p>
         * 
         * @param offeringId
         *        The ID of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * <p>
         * The number of device slots you wish to purchase in an offering request.
         * </p>
         * 
         * @param quantity
         *        The number of device slots you wish to purchase in an offering request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * The ID of the offering promotion to be applied to the purchase.
         * </p>
         * 
         * @param offeringPromotionId
         *        The ID of the offering promotion to be applied to the purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringPromotionId(String offeringPromotionId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String offeringId;

        private Integer quantity;

        private String offeringPromotionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseOfferingRequest model) {
            offeringId(model.offeringId);
            quantity(model.quantity);
            offeringPromotionId(model.offeringPromotionId);
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final String getOfferingPromotionId() {
            return offeringPromotionId;
        }

        @Override
        public final Builder offeringPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
            return this;
        }

        public final void setOfferingPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PurchaseOfferingRequest build() {
            return new PurchaseOfferingRequest(this);
        }
    }
}
