/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse;
import software.amazon.awssdk.services.devicefarm.model.Project;

public final class ListProjectsPaginator
implements SdkIterable<ListProjectsResponse> {
    private final DeviceFarmClient client;
    private final ListProjectsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListProjectsPaginator(DeviceFarmClient client, ListProjectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProjectsResponseFetcher();
    }

    public Iterator<ListProjectsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Project> projects() {
        Function<ListProjectsResponse, Iterator> getIterator = response -> response != null ? response.projects().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListProjectsResponseFetcher
    implements NextPageFetcher<ListProjectsResponse> {
        private ListProjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListProjectsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListProjectsResponse nextPage(ListProjectsResponse previousPage) {
            if (previousPage == null) {
                return ListProjectsPaginator.this.client.listProjects(ListProjectsPaginator.this.firstRequest);
            }
            return ListProjectsPaginator.this.client.listProjects((ListProjectsRequest)((Object)ListProjectsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

