/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse;
import software.amazon.awssdk.services.devicefarm.model.Suite;

public final class ListSuitesPaginator
implements SdkIterable<ListSuitesResponse> {
    private final DeviceFarmClient client;
    private final ListSuitesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListSuitesPaginator(DeviceFarmClient client, ListSuitesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSuitesResponseFetcher();
    }

    public Iterator<ListSuitesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Suite> suites() {
        Function<ListSuitesResponse, Iterator> getIterator = response -> response != null ? response.suites().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListSuitesResponseFetcher
    implements NextPageFetcher<ListSuitesResponse> {
        private ListSuitesResponseFetcher() {
        }

        public boolean hasNextPage(ListSuitesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListSuitesResponse nextPage(ListSuitesResponse previousPage) {
            if (previousPage == null) {
                return ListSuitesPaginator.this.client.listSuites(ListSuitesPaginator.this.firstRequest);
            }
            return ListSuitesPaginator.this.client.listSuites((ListSuitesRequest)((Object)ListSuitesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

