/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths;

@SdkInternalApi
public class CustomerArtifactPathsMarshaller {
    private static final MarshallingInfo<List> IOSPATHS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iosPaths").build();
    private static final MarshallingInfo<List> ANDROIDPATHS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("androidPaths").build();
    private static final MarshallingInfo<List> DEVICEHOSTPATHS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deviceHostPaths").build();
    private static final CustomerArtifactPathsMarshaller INSTANCE = new CustomerArtifactPathsMarshaller();

    public static CustomerArtifactPathsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CustomerArtifactPaths customerArtifactPaths, ProtocolMarshaller protocolMarshaller) {
        if (customerArtifactPaths == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(customerArtifactPaths.iosPaths(), IOSPATHS_BINDING);
            protocolMarshaller.marshall(customerArtifactPaths.androidPaths(), ANDROIDPATHS_BINDING);
            protocolMarshaller.marshall(customerArtifactPaths.deviceHostPaths(), DEVICEHOSTPATHS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

