/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.IncompatibilityMessage;

@SdkInternalApi
public class IncompatibilityMessageMarshaller {
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final IncompatibilityMessageMarshaller INSTANCE = new IncompatibilityMessageMarshaller();

    public static IncompatibilityMessageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(IncompatibilityMessage incompatibilityMessage, ProtocolMarshaller protocolMarshaller) {
        if (incompatibilityMessage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)incompatibilityMessage.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)incompatibilityMessage.typeString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

