/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.DevicePoolMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a collection of device types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DevicePool implements StructuredPojo, ToCopyableBuilder<DevicePool.Builder, DevicePool> {
    private final String arn;

    private final String name;

    private final String description;

    private final String type;

    private final List<Rule> rules;

    private DevicePool(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The device pool's ARN.
     * </p>
     * 
     * @return The device pool's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The device pool's name.
     * </p>
     * 
     * @return The device pool's name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The device pool's description.
     * </p>
     * 
     * @return The device pool's description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The device pool's type.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CURATED: A device pool that is created and managed by AWS Device Farm.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRIVATE: A device pool that is created and managed by the device pool developer.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DevicePoolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The device pool's type.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CURATED: A device pool that is created and managed by AWS Device Farm.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRIVATE: A device pool that is created and managed by the device pool developer.
     *         </p>
     *         </li>
     * @see DevicePoolType
     */
    public DevicePoolType type() {
        return DevicePoolType.fromValue(type);
    }

    /**
     * <p>
     * The device pool's type.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CURATED: A device pool that is created and managed by AWS Device Farm.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRIVATE: A device pool that is created and managed by the device pool developer.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DevicePoolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The device pool's type.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CURATED: A device pool that is created and managed by AWS Device Farm.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRIVATE: A device pool that is created and managed by the device pool developer.
     *         </p>
     *         </li>
     * @see DevicePoolType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * Information about the device pool's rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the device pool's rules.
     */
    public List<Rule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(rules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DevicePool)) {
            return false;
        }
        DevicePool other = (DevicePool) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(typeString(), other.typeString())
                && Objects.equals(rules(), other.rules());
    }

    @Override
    public String toString() {
        return ToString.builder("DevicePool").add("Arn", arn()).add("Name", name()).add("Description", description())
                .add("Type", typeString()).add("Rules", rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.of(clazz.cast(arn()));
        case "name":
            return Optional.of(clazz.cast(name()));
        case "description":
            return Optional.of(clazz.cast(description()));
        case "type":
            return Optional.of(clazz.cast(typeString()));
        case "rules":
            return Optional.of(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DevicePoolMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DevicePool> {
        /**
         * <p>
         * The device pool's ARN.
         * </p>
         * 
         * @param arn
         *        The device pool's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The device pool's name.
         * </p>
         * 
         * @param name
         *        The device pool's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The device pool's description.
         * </p>
         * 
         * @param description
         *        The device pool's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The device pool's type.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CURATED: A device pool that is created and managed by AWS Device Farm.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRIVATE: A device pool that is created and managed by the device pool developer.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The device pool's type.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CURATED: A device pool that is created and managed by AWS Device Farm.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRIVATE: A device pool that is created and managed by the device pool developer.
         *        </p>
         *        </li>
         * @see DevicePoolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DevicePoolType
         */
        Builder type(String type);

        /**
         * <p>
         * The device pool's type.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CURATED: A device pool that is created and managed by AWS Device Farm.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRIVATE: A device pool that is created and managed by the device pool developer.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The device pool's type.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CURATED: A device pool that is created and managed by AWS Device Farm.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRIVATE: A device pool that is created and managed by the device pool developer.
         *        </p>
         *        </li>
         * @see DevicePoolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DevicePoolType
         */
        Builder type(DevicePoolType type);

        /**
         * <p>
         * Information about the device pool's rules.
         * </p>
         * 
         * @param rules
         *        Information about the device pool's rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         * <p>
         * Information about the device pool's rules.
         * </p>
         * 
         * @param rules
         *        Information about the device pool's rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String type;

        private List<Rule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(DevicePool model) {
            arn(model.arn);
            name(model.name);
            description(model.description);
            type(model.type);
            rules(model.rules);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DevicePoolType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<Rule.Builder> getRules() {
            return rules != null ? rules.stream().map(Rule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RulesCopier.copyFromBuilder(rules);
        }

        @Override
        public DevicePool build() {
            return new DevicePool(this);
        }
    }
}
