/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.OfferingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the metadata of a device offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Offering implements StructuredPojo, ToCopyableBuilder<Offering.Builder, Offering> {
    private final String id;

    private final String description;

    private final String type;

    private final String platform;

    private final List<RecurringCharge> recurringCharges;

    private Offering(BuilderImpl builder) {
        this.id = builder.id;
        this.description = builder.description;
        this.type = builder.type;
        this.platform = builder.platform;
        this.recurringCharges = builder.recurringCharges;
    }

    /**
     * <p>
     * The ID that corresponds to a device offering.
     * </p>
     * 
     * @return The ID that corresponds to a device offering.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * A string describing the offering.
     * </p>
     * 
     * @return A string describing the offering.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The type of offering (e.g., "RECURRING") for a device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OfferingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of offering (e.g., "RECURRING") for a device.
     * @see OfferingType
     */
    public OfferingType type() {
        return OfferingType.fromValue(type);
    }

    /**
     * <p>
     * The type of offering (e.g., "RECURRING") for a device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OfferingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of offering (e.g., "RECURRING") for a device.
     * @see OfferingType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The platform of the device (e.g., ANDROID or IOS).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link DevicePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformString}.
     * </p>
     * 
     * @return The platform of the device (e.g., ANDROID or IOS).
     * @see DevicePlatform
     */
    public DevicePlatform platform() {
        return DevicePlatform.fromValue(platform);
    }

    /**
     * <p>
     * The platform of the device (e.g., ANDROID or IOS).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link DevicePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformString}.
     * </p>
     * 
     * @return The platform of the device (e.g., ANDROID or IOS).
     * @see DevicePlatform
     */
    public String platformString() {
        return platform;
    }

    /**
     * <p>
     * Specifies whether there are recurring charges for the offering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies whether there are recurring charges for the offering.
     */
    public List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(platformString());
        hashCode = 31 * hashCode + Objects.hashCode(recurringCharges());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Offering)) {
            return false;
        }
        Offering other = (Offering) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(description(), other.description())
                && Objects.equals(typeString(), other.typeString()) && Objects.equals(platformString(), other.platformString())
                && Objects.equals(recurringCharges(), other.recurringCharges());
    }

    @Override
    public String toString() {
        return ToString.builder("Offering").add("Id", id()).add("Description", description()).add("Type", typeString())
                .add("Platform", platformString()).add("RecurringCharges", recurringCharges()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.of(clazz.cast(id()));
        case "description":
            return Optional.of(clazz.cast(description()));
        case "type":
            return Optional.of(clazz.cast(typeString()));
        case "platform":
            return Optional.of(clazz.cast(platformString()));
        case "recurringCharges":
            return Optional.of(clazz.cast(recurringCharges()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OfferingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Offering> {
        /**
         * <p>
         * The ID that corresponds to a device offering.
         * </p>
         * 
         * @param id
         *        The ID that corresponds to a device offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A string describing the offering.
         * </p>
         * 
         * @param description
         *        A string describing the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of offering (e.g., "RECURRING") for a device.
         * </p>
         * 
         * @param type
         *        The type of offering (e.g., "RECURRING") for a device.
         * @see OfferingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of offering (e.g., "RECURRING") for a device.
         * </p>
         * 
         * @param type
         *        The type of offering (e.g., "RECURRING") for a device.
         * @see OfferingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingType
         */
        Builder type(OfferingType type);

        /**
         * <p>
         * The platform of the device (e.g., ANDROID or IOS).
         * </p>
         * 
         * @param platform
         *        The platform of the device (e.g., ANDROID or IOS).
         * @see DevicePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DevicePlatform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform of the device (e.g., ANDROID or IOS).
         * </p>
         * 
         * @param platform
         *        The platform of the device (e.g., ANDROID or IOS).
         * @see DevicePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DevicePlatform
         */
        Builder platform(DevicePlatform platform);

        /**
         * <p>
         * Specifies whether there are recurring charges for the offering.
         * </p>
         * 
         * @param recurringCharges
         *        Specifies whether there are recurring charges for the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * Specifies whether there are recurring charges for the offering.
         * </p>
         * 
         * @param recurringCharges
         *        Specifies whether there are recurring charges for the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String description;

        private String type;

        private String platform;

        private List<RecurringCharge> recurringCharges;

        private BuilderImpl() {
        }

        private BuilderImpl(Offering model) {
            id(model.id);
            description(model.description);
            type(model.type);
            platform(model.platform);
            recurringCharges(model.recurringCharges);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OfferingType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(DevicePlatform platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Collection<RecurringCharge.Builder> getRecurringCharges() {
            return recurringCharges != null ? recurringCharges.stream().map(RecurringCharge::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargesCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        public Offering build() {
            return new Offering(this);
        }
    }
}
