/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.RemoteAccessSessionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about the remote access session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RemoteAccessSession implements StructuredPojo, ToCopyableBuilder<RemoteAccessSession.Builder, RemoteAccessSession> {
    private final String arn;

    private final String name;

    private final Instant created;

    private final String status;

    private final String result;

    private final String message;

    private final Instant started;

    private final Instant stopped;

    private final Device device;

    private final Boolean remoteDebugEnabled;

    private final String hostAddress;

    private final String clientId;

    private final String billingMethod;

    private final DeviceMinutes deviceMinutes;

    private final String endpoint;

    private final String deviceUdid;

    private RemoteAccessSession(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.message = builder.message;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.device = builder.device;
        this.remoteDebugEnabled = builder.remoteDebugEnabled;
        this.hostAddress = builder.hostAddress;
        this.clientId = builder.clientId;
        this.billingMethod = builder.billingMethod;
        this.deviceMinutes = builder.deviceMinutes;
        this.endpoint = builder.endpoint;
        this.deviceUdid = builder.deviceUdid;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the remote access session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the remote access session.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the remote access session.
     * </p>
     * 
     * @return The name of the remote access session.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The date and time the remote access session was created.
     * </p>
     * 
     * @return The date and time the remote access session was created.
     */
    public Instant created() {
        return created;
    }

    /**
     * <p>
     * The status of the remote access session. Can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_CONCURRENCY: A pending concurrency status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_DEVICE: A pending device status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING: A processing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULING: A scheduling status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARING: A preparing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING: A running status.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED: A completed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPING: A stopping status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The status of the remote access session. Can be any of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_CONCURRENCY: A pending concurrency status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_DEVICE: A pending device status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING: A processing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULING: A scheduling status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARING: A preparing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING: A running status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED: A completed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPING: A stopping status.
     *         </p>
     *         </li>
     * @see ExecutionStatus
     */
    public ExecutionStatus status() {
        return ExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the remote access session. Can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_CONCURRENCY: A pending concurrency status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_DEVICE: A pending device status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING: A processing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULING: A scheduling status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARING: A preparing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING: A running status.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED: A completed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPING: A stopping status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The status of the remote access session. Can be any of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_CONCURRENCY: A pending concurrency status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_DEVICE: A pending device status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING: A processing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULING: A scheduling status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARING: A preparing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING: A running status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED: A completed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPING: A stopping status.
     *         </p>
     *         </li>
     * @see ExecutionStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * The result of the remote access session. Can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED: A passing condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED: A warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: A failed condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED: A skipped condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED: An error condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED: A stopped condition.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultString}.
     * </p>
     * 
     * @return The result of the remote access session. Can be any of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED: A passing condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED: A warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: A failed condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED: A skipped condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED: An error condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED: A stopped condition.
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public ExecutionResult result() {
        return ExecutionResult.fromValue(result);
    }

    /**
     * <p>
     * The result of the remote access session. Can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED: A passing condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED: A warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: A failed condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED: A skipped condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED: An error condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED: A stopped condition.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultString}.
     * </p>
     * 
     * @return The result of the remote access session. Can be any of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED: A passing condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED: A warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: A failed condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED: A skipped condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED: An error condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED: A stopped condition.
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public String resultString() {
        return result;
    }

    /**
     * <p>
     * A message about the remote access session.
     * </p>
     * 
     * @return A message about the remote access session.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The date and time the remote access session was started.
     * </p>
     * 
     * @return The date and time the remote access session was started.
     */
    public Instant started() {
        return started;
    }

    /**
     * <p>
     * The date and time the remote access session was stopped.
     * </p>
     * 
     * @return The date and time the remote access session was stopped.
     */
    public Instant stopped() {
        return stopped;
    }

    /**
     * <p>
     * The device (phone or tablet) used in the remote access session.
     * </p>
     * 
     * @return The device (phone or tablet) used in the remote access session.
     */
    public Device device() {
        return device;
    }

    /**
     * <p>
     * This flag is set to <code>true</code> if remote debugging is enabled for the remote access session.
     * </p>
     * 
     * @return This flag is set to <code>true</code> if remote debugging is enabled for the remote access session.
     */
    public Boolean remoteDebugEnabled() {
        return remoteDebugEnabled;
    }

    /**
     * <p>
     * IP address of the EC2 host where you need to connect to remotely debug devices. Only returned if remote debugging
     * is enabled for the remote access session.
     * </p>
     * 
     * @return IP address of the EC2 host where you need to connect to remotely debug devices. Only returned if remote
     *         debugging is enabled for the remote access session.
     */
    public String hostAddress() {
        return hostAddress;
    }

    /**
     * <p>
     * Unique identifier of your client for the remote access session. Only returned if remote debugging is enabled for
     * the remote access session.
     * </p>
     * 
     * @return Unique identifier of your client for the remote access session. Only returned if remote debugging is
     *         enabled for the remote access session.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The billing method of the remote access session. Possible values include <code>METERED</code> or
     * <code>UNMETERED</code>. For more information about metered devices, see <a
     * href="http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS Device
     * Farm terminology</a>."
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodString}.
     * </p>
     * 
     * @return The billing method of the remote access session. Possible values include <code>METERED</code> or
     *         <code>UNMETERED</code>. For more information about metered devices, see <a
     *         href="http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS
     *         Device Farm terminology</a>."
     * @see BillingMethod
     */
    public BillingMethod billingMethod() {
        return BillingMethod.fromValue(billingMethod);
    }

    /**
     * <p>
     * The billing method of the remote access session. Possible values include <code>METERED</code> or
     * <code>UNMETERED</code>. For more information about metered devices, see <a
     * href="http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS Device
     * Farm terminology</a>."
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodString}.
     * </p>
     * 
     * @return The billing method of the remote access session. Possible values include <code>METERED</code> or
     *         <code>UNMETERED</code>. For more information about metered devices, see <a
     *         href="http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS
     *         Device Farm terminology</a>."
     * @see BillingMethod
     */
    public String billingMethodString() {
        return billingMethod;
    }

    /**
     * <p>
     * The number of minutes a device is used in a remote access sesssion (including setup and teardown minutes).
     * </p>
     * 
     * @return The number of minutes a device is used in a remote access sesssion (including setup and teardown
     *         minutes).
     */
    public DeviceMinutes deviceMinutes() {
        return deviceMinutes;
    }

    /**
     * <p>
     * The endpoint for the remote access sesssion.
     * </p>
     * 
     * @return The endpoint for the remote access sesssion.
     */
    public String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * Unique device identifier for the remote device. Only returned if remote debugging is enabled for the remote
     * access session.
     * </p>
     * 
     * @return Unique device identifier for the remote device. Only returned if remote debugging is enabled for the
     *         remote access session.
     */
    public String deviceUdid() {
        return deviceUdid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        hashCode = 31 * hashCode + Objects.hashCode(resultString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(started());
        hashCode = 31 * hashCode + Objects.hashCode(stopped());
        hashCode = 31 * hashCode + Objects.hashCode(device());
        hashCode = 31 * hashCode + Objects.hashCode(remoteDebugEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hostAddress());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(billingMethodString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(deviceUdid());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteAccessSession)) {
            return false;
        }
        RemoteAccessSession other = (RemoteAccessSession) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(created(), other.created()) && Objects.equals(statusString(), other.statusString())
                && Objects.equals(resultString(), other.resultString()) && Objects.equals(message(), other.message())
                && Objects.equals(started(), other.started()) && Objects.equals(stopped(), other.stopped())
                && Objects.equals(device(), other.device()) && Objects.equals(remoteDebugEnabled(), other.remoteDebugEnabled())
                && Objects.equals(hostAddress(), other.hostAddress()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(billingMethodString(), other.billingMethodString())
                && Objects.equals(deviceMinutes(), other.deviceMinutes()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(deviceUdid(), other.deviceUdid());
    }

    @Override
    public String toString() {
        return ToString.builder("RemoteAccessSession").add("Arn", arn()).add("Name", name()).add("Created", created())
                .add("Status", statusString()).add("Result", resultString()).add("Message", message()).add("Started", started())
                .add("Stopped", stopped()).add("Device", device()).add("RemoteDebugEnabled", remoteDebugEnabled())
                .add("HostAddress", hostAddress()).add("ClientId", clientId()).add("BillingMethod", billingMethodString())
                .add("DeviceMinutes", deviceMinutes()).add("Endpoint", endpoint()).add("DeviceUdid", deviceUdid()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.of(clazz.cast(arn()));
        case "name":
            return Optional.of(clazz.cast(name()));
        case "created":
            return Optional.of(clazz.cast(created()));
        case "status":
            return Optional.of(clazz.cast(statusString()));
        case "result":
            return Optional.of(clazz.cast(resultString()));
        case "message":
            return Optional.of(clazz.cast(message()));
        case "started":
            return Optional.of(clazz.cast(started()));
        case "stopped":
            return Optional.of(clazz.cast(stopped()));
        case "device":
            return Optional.of(clazz.cast(device()));
        case "remoteDebugEnabled":
            return Optional.of(clazz.cast(remoteDebugEnabled()));
        case "hostAddress":
            return Optional.of(clazz.cast(hostAddress()));
        case "clientId":
            return Optional.of(clazz.cast(clientId()));
        case "billingMethod":
            return Optional.of(clazz.cast(billingMethodString()));
        case "deviceMinutes":
            return Optional.of(clazz.cast(deviceMinutes()));
        case "endpoint":
            return Optional.of(clazz.cast(endpoint()));
        case "deviceUdid":
            return Optional.of(clazz.cast(deviceUdid()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RemoteAccessSessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RemoteAccessSession> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the remote access session.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the remote access session.
         * </p>
         * 
         * @param name
         *        The name of the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The date and time the remote access session was created.
         * </p>
         * 
         * @param created
         *        The date and time the remote access session was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The status of the remote access session. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY: A pending concurrency status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE: A pending device status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING: A scheduling status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING: A preparing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING: A running status.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED: A completed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING: A stopping status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the remote access session. Can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY: A pending concurrency status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE: A pending device status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING: A scheduling status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING: A preparing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING: A running status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED: A completed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING: A stopping status.
         *        </p>
         *        </li>
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the remote access session. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY: A pending concurrency status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE: A pending device status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING: A scheduling status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING: A preparing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING: A running status.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED: A completed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING: A stopping status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the remote access session. Can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY: A pending concurrency status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE: A pending device status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING: A scheduling status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING: A preparing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING: A running status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED: A completed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING: A stopping status.
         *        </p>
         *        </li>
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * The result of the remote access session. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The result of the remote access session. Can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(String result);

        /**
         * <p>
         * The result of the remote access session. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The result of the remote access session. Can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(ExecutionResult result);

        /**
         * <p>
         * A message about the remote access session.
         * </p>
         * 
         * @param message
         *        A message about the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The date and time the remote access session was started.
         * </p>
         * 
         * @param started
         *        The date and time the remote access session was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder started(Instant started);

        /**
         * <p>
         * The date and time the remote access session was stopped.
         * </p>
         * 
         * @param stopped
         *        The date and time the remote access session was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopped(Instant stopped);

        /**
         * <p>
         * The device (phone or tablet) used in the remote access session.
         * </p>
         * 
         * @param device
         *        The device (phone or tablet) used in the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(Device device);

        /**
         * <p>
         * The device (phone or tablet) used in the remote access session.
         * </p>
         * This is a convenience that creates an instance of the {@link Device.Builder} avoiding the need to create one
         * manually via {@link Device#builder()}.
         *
         * When the {@link Consumer} completes, {@link Device.Builder#build()} is called immediately and its result is
         * passed to {@link #device(Device)}.
         * 
         * @param device
         *        a consumer that will call methods on {@link Device.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #device(Device)
         */
        default Builder device(Consumer<Device.Builder> device) {
            return device(Device.builder().apply(device).build());
        }

        /**
         * <p>
         * This flag is set to <code>true</code> if remote debugging is enabled for the remote access session.
         * </p>
         * 
         * @param remoteDebugEnabled
         *        This flag is set to <code>true</code> if remote debugging is enabled for the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteDebugEnabled(Boolean remoteDebugEnabled);

        /**
         * <p>
         * IP address of the EC2 host where you need to connect to remotely debug devices. Only returned if remote
         * debugging is enabled for the remote access session.
         * </p>
         * 
         * @param hostAddress
         *        IP address of the EC2 host where you need to connect to remotely debug devices. Only returned if
         *        remote debugging is enabled for the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostAddress(String hostAddress);

        /**
         * <p>
         * Unique identifier of your client for the remote access session. Only returned if remote debugging is enabled
         * for the remote access session.
         * </p>
         * 
         * @param clientId
         *        Unique identifier of your client for the remote access session. Only returned if remote debugging is
         *        enabled for the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The billing method of the remote access session. Possible values include <code>METERED</code> or
         * <code>UNMETERED</code>. For more information about metered devices, see <a
         * href="http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS
         * Device Farm terminology</a>."
         * </p>
         * 
         * @param billingMethod
         *        The billing method of the remote access session. Possible values include <code>METERED</code> or
         *        <code>UNMETERED</code>. For more information about metered devices, see <a
         *        href="http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology"
         *        >AWS Device Farm terminology</a>."
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(String billingMethod);

        /**
         * <p>
         * The billing method of the remote access session. Possible values include <code>METERED</code> or
         * <code>UNMETERED</code>. For more information about metered devices, see <a
         * href="http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS
         * Device Farm terminology</a>."
         * </p>
         * 
         * @param billingMethod
         *        The billing method of the remote access session. Possible values include <code>METERED</code> or
         *        <code>UNMETERED</code>. For more information about metered devices, see <a
         *        href="http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology"
         *        >AWS Device Farm terminology</a>."
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(BillingMethod billingMethod);

        /**
         * <p>
         * The number of minutes a device is used in a remote access sesssion (including setup and teardown minutes).
         * </p>
         * 
         * @param deviceMinutes
         *        The number of minutes a device is used in a remote access sesssion (including setup and teardown
         *        minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMinutes(DeviceMinutes deviceMinutes);

        /**
         * <p>
         * The number of minutes a device is used in a remote access sesssion (including setup and teardown minutes).
         * </p>
         * This is a convenience that creates an instance of the {@link DeviceMinutes.Builder} avoiding the need to
         * create one manually via {@link DeviceMinutes#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceMinutes.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceMinutes(DeviceMinutes)}.
         * 
         * @param deviceMinutes
         *        a consumer that will call methods on {@link DeviceMinutes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceMinutes(DeviceMinutes)
         */
        default Builder deviceMinutes(Consumer<DeviceMinutes.Builder> deviceMinutes) {
            return deviceMinutes(DeviceMinutes.builder().apply(deviceMinutes).build());
        }

        /**
         * <p>
         * The endpoint for the remote access sesssion.
         * </p>
         * 
         * @param endpoint
         *        The endpoint for the remote access sesssion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * Unique device identifier for the remote device. Only returned if remote debugging is enabled for the remote
         * access session.
         * </p>
         * 
         * @param deviceUdid
         *        Unique device identifier for the remote device. Only returned if remote debugging is enabled for the
         *        remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceUdid(String deviceUdid);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private Instant created;

        private String status;

        private String result;

        private String message;

        private Instant started;

        private Instant stopped;

        private Device device;

        private Boolean remoteDebugEnabled;

        private String hostAddress;

        private String clientId;

        private String billingMethod;

        private DeviceMinutes deviceMinutes;

        private String endpoint;

        private String deviceUdid;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteAccessSession model) {
            arn(model.arn);
            name(model.name);
            created(model.created);
            status(model.status);
            result(model.result);
            message(model.message);
            started(model.started);
            stopped(model.stopped);
            device(model.device);
            remoteDebugEnabled(model.remoteDebugEnabled);
            hostAddress(model.hostAddress);
            clientId(model.clientId);
            billingMethod(model.billingMethod);
            deviceMinutes(model.deviceMinutes);
            endpoint(model.endpoint);
            deviceUdid(model.deviceUdid);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreated() {
            return created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getResult() {
            return result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getStarted() {
            return started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        public final Instant getStopped() {
            return stopped;
        }

        @Override
        public final Builder stopped(Instant stopped) {
            this.stopped = stopped;
            return this;
        }

        public final void setStopped(Instant stopped) {
            this.stopped = stopped;
        }

        public final Device.Builder getDevice() {
            return device != null ? device.toBuilder() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        public final Boolean getRemoteDebugEnabled() {
            return remoteDebugEnabled;
        }

        @Override
        public final Builder remoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
            return this;
        }

        public final void setRemoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
        }

        public final String getHostAddress() {
            return hostAddress;
        }

        @Override
        public final Builder hostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
            return this;
        }

        public final void setHostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getBillingMethod() {
            return billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        public final DeviceMinutes.Builder getDeviceMinutes() {
            return deviceMinutes != null ? deviceMinutes.toBuilder() : null;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        public final void setDeviceMinutes(DeviceMinutes.BuilderImpl deviceMinutes) {
            this.deviceMinutes = deviceMinutes != null ? deviceMinutes.build() : null;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getDeviceUdid() {
            return deviceUdid;
        }

        @Override
        public final Builder deviceUdid(String deviceUdid) {
            this.deviceUdid = deviceUdid;
            return this;
        }

        public final void setDeviceUdid(String deviceUdid) {
            this.deviceUdid = deviceUdid;
        }

        @Override
        public RemoteAccessSession build() {
            return new RemoteAccessSession(this);
        }
    }
}
