/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.TrialMinutesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about free trial device minutes for an AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TrialMinutes implements StructuredPojo, ToCopyableBuilder<TrialMinutes.Builder, TrialMinutes> {
    private final Double total;

    private final Double remaining;

    private TrialMinutes(BuilderImpl builder) {
        this.total = builder.total;
        this.remaining = builder.remaining;
    }

    /**
     * <p>
     * The total number of free trial minutes that the account started with.
     * </p>
     * 
     * @return The total number of free trial minutes that the account started with.
     */
    public Double total() {
        return total;
    }

    /**
     * <p>
     * The number of free trial minutes remaining in the account.
     * </p>
     * 
     * @return The number of free trial minutes remaining in the account.
     */
    public Double remaining() {
        return remaining;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(remaining());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialMinutes)) {
            return false;
        }
        TrialMinutes other = (TrialMinutes) obj;
        return Objects.equals(total(), other.total()) && Objects.equals(remaining(), other.remaining());
    }

    @Override
    public String toString() {
        return ToString.builder("TrialMinutes").add("Total", total()).add("Remaining", remaining()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "total":
            return Optional.of(clazz.cast(total()));
        case "remaining":
            return Optional.of(clazz.cast(remaining()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrialMinutesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TrialMinutes> {
        /**
         * <p>
         * The total number of free trial minutes that the account started with.
         * </p>
         * 
         * @param total
         *        The total number of free trial minutes that the account started with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Double total);

        /**
         * <p>
         * The number of free trial minutes remaining in the account.
         * </p>
         * 
         * @param remaining
         *        The number of free trial minutes remaining in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remaining(Double remaining);
    }

    static final class BuilderImpl implements Builder {
        private Double total;

        private Double remaining;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialMinutes model) {
            total(model.total);
            remaining(model.remaining);
        }

        public final Double getTotal() {
            return total;
        }

        @Override
        public final Builder total(Double total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Double total) {
            this.total = total;
        }

        public final Double getRemaining() {
            return remaining;
        }

        @Override
        public final Builder remaining(Double remaining) {
            this.remaining = remaining;
            return this;
        }

        public final void setRemaining(Double remaining) {
            this.remaining = remaining;
        }

        @Override
        public TrialMinutes build() {
            return new TrialMinutes(this);
        }
    }
}
