/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateNetworkProfileRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<UpdateNetworkProfileRequest.Builder, UpdateNetworkProfileRequest> {
    private final String arn;

    private final String name;

    private final String description;

    private final String type;

    private final Long uplinkBandwidthBits;

    private final Long downlinkBandwidthBits;

    private final Long uplinkDelayMs;

    private final Long downlinkDelayMs;

    private final Long uplinkJitterMs;

    private final Long downlinkJitterMs;

    private final Integer uplinkLossPercent;

    private final Integer downlinkLossPercent;

    private UpdateNetworkProfileRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.uplinkBandwidthBits = builder.uplinkBandwidthBits;
        this.downlinkBandwidthBits = builder.downlinkBandwidthBits;
        this.uplinkDelayMs = builder.uplinkDelayMs;
        this.downlinkDelayMs = builder.downlinkDelayMs;
        this.uplinkJitterMs = builder.uplinkJitterMs;
        this.downlinkJitterMs = builder.downlinkJitterMs;
        this.uplinkLossPercent = builder.uplinkLossPercent;
        this.downlinkLossPercent = builder.downlinkLossPercent;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project that you wish to update network profile settings.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project that you wish to update network profile settings.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the network profile about which you are returning information.
     * </p>
     * 
     * @return The name of the network profile about which you are returning information.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The descriptoin of the network profile about which you are returning information.
     * </p>
     * 
     * @return The descriptoin of the network profile about which you are returning information.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The type of network profile you wish to return information about. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NetworkProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of network profile you wish to return information about. Valid values are listed below.
     * @see NetworkProfileType
     */
    public NetworkProfileType type() {
        return NetworkProfileType.fromValue(type);
    }

    /**
     * <p>
     * The type of network profile you wish to return information about. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NetworkProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of network profile you wish to return information about. Valid values are listed below.
     * @see NetworkProfileType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The data throughput rate in bits per second, as an integer from 0 to 104857600.
     * </p>
     * 
     * @return The data throughput rate in bits per second, as an integer from 0 to 104857600.
     */
    public Long uplinkBandwidthBits() {
        return uplinkBandwidthBits;
    }

    /**
     * <p>
     * The data throughput rate in bits per second, as an integer from 0 to 104857600.
     * </p>
     * 
     * @return The data throughput rate in bits per second, as an integer from 0 to 104857600.
     */
    public Long downlinkBandwidthBits() {
        return downlinkBandwidthBits;
    }

    /**
     * <p>
     * Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
     * </p>
     * 
     * @return Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
     */
    public Long uplinkDelayMs() {
        return uplinkDelayMs;
    }

    /**
     * <p>
     * Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
     * </p>
     * 
     * @return Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
     */
    public Long downlinkDelayMs() {
        return downlinkDelayMs;
    }

    /**
     * <p>
     * Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
     * </p>
     * 
     * @return Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
     */
    public Long uplinkJitterMs() {
        return uplinkJitterMs;
    }

    /**
     * <p>
     * Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
     * </p>
     * 
     * @return Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
     */
    public Long downlinkJitterMs() {
        return downlinkJitterMs;
    }

    /**
     * <p>
     * Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
     * </p>
     * 
     * @return Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
     */
    public Integer uplinkLossPercent() {
        return uplinkLossPercent;
    }

    /**
     * <p>
     * Proportion of received packets that fail to arrive from 0 to 100 percent.
     * </p>
     * 
     * @return Proportion of received packets that fail to arrive from 0 to 100 percent.
     */
    public Integer downlinkLossPercent() {
        return downlinkLossPercent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(uplinkBandwidthBits());
        hashCode = 31 * hashCode + Objects.hashCode(downlinkBandwidthBits());
        hashCode = 31 * hashCode + Objects.hashCode(uplinkDelayMs());
        hashCode = 31 * hashCode + Objects.hashCode(downlinkDelayMs());
        hashCode = 31 * hashCode + Objects.hashCode(uplinkJitterMs());
        hashCode = 31 * hashCode + Objects.hashCode(downlinkJitterMs());
        hashCode = 31 * hashCode + Objects.hashCode(uplinkLossPercent());
        hashCode = 31 * hashCode + Objects.hashCode(downlinkLossPercent());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNetworkProfileRequest)) {
            return false;
        }
        UpdateNetworkProfileRequest other = (UpdateNetworkProfileRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(typeString(), other.typeString())
                && Objects.equals(uplinkBandwidthBits(), other.uplinkBandwidthBits())
                && Objects.equals(downlinkBandwidthBits(), other.downlinkBandwidthBits())
                && Objects.equals(uplinkDelayMs(), other.uplinkDelayMs())
                && Objects.equals(downlinkDelayMs(), other.downlinkDelayMs())
                && Objects.equals(uplinkJitterMs(), other.uplinkJitterMs())
                && Objects.equals(downlinkJitterMs(), other.downlinkJitterMs())
                && Objects.equals(uplinkLossPercent(), other.uplinkLossPercent())
                && Objects.equals(downlinkLossPercent(), other.downlinkLossPercent());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateNetworkProfileRequest").add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("Type", typeString()).add("UplinkBandwidthBits", uplinkBandwidthBits())
                .add("DownlinkBandwidthBits", downlinkBandwidthBits()).add("UplinkDelayMs", uplinkDelayMs())
                .add("DownlinkDelayMs", downlinkDelayMs()).add("UplinkJitterMs", uplinkJitterMs())
                .add("DownlinkJitterMs", downlinkJitterMs()).add("UplinkLossPercent", uplinkLossPercent())
                .add("DownlinkLossPercent", downlinkLossPercent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.of(clazz.cast(arn()));
        case "name":
            return Optional.of(clazz.cast(name()));
        case "description":
            return Optional.of(clazz.cast(description()));
        case "type":
            return Optional.of(clazz.cast(typeString()));
        case "uplinkBandwidthBits":
            return Optional.of(clazz.cast(uplinkBandwidthBits()));
        case "downlinkBandwidthBits":
            return Optional.of(clazz.cast(downlinkBandwidthBits()));
        case "uplinkDelayMs":
            return Optional.of(clazz.cast(uplinkDelayMs()));
        case "downlinkDelayMs":
            return Optional.of(clazz.cast(downlinkDelayMs()));
        case "uplinkJitterMs":
            return Optional.of(clazz.cast(uplinkJitterMs()));
        case "downlinkJitterMs":
            return Optional.of(clazz.cast(downlinkJitterMs()));
        case "uplinkLossPercent":
            return Optional.of(clazz.cast(uplinkLossPercent()));
        case "downlinkLossPercent":
            return Optional.of(clazz.cast(downlinkLossPercent()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmRequest.Builder, CopyableBuilder<Builder, UpdateNetworkProfileRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project that you wish to update network profile settings.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the project that you wish to update network profile settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the network profile about which you are returning information.
         * </p>
         * 
         * @param name
         *        The name of the network profile about which you are returning information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The descriptoin of the network profile about which you are returning information.
         * </p>
         * 
         * @param description
         *        The descriptoin of the network profile about which you are returning information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of network profile you wish to return information about. Valid values are listed below.
         * </p>
         * 
         * @param type
         *        The type of network profile you wish to return information about. Valid values are listed below.
         * @see NetworkProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProfileType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of network profile you wish to return information about. Valid values are listed below.
         * </p>
         * 
         * @param type
         *        The type of network profile you wish to return information about. Valid values are listed below.
         * @see NetworkProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProfileType
         */
        Builder type(NetworkProfileType type);

        /**
         * <p>
         * The data throughput rate in bits per second, as an integer from 0 to 104857600.
         * </p>
         * 
         * @param uplinkBandwidthBits
         *        The data throughput rate in bits per second, as an integer from 0 to 104857600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uplinkBandwidthBits(Long uplinkBandwidthBits);

        /**
         * <p>
         * The data throughput rate in bits per second, as an integer from 0 to 104857600.
         * </p>
         * 
         * @param downlinkBandwidthBits
         *        The data throughput rate in bits per second, as an integer from 0 to 104857600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkBandwidthBits(Long downlinkBandwidthBits);

        /**
         * <p>
         * Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
         * </p>
         * 
         * @param uplinkDelayMs
         *        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uplinkDelayMs(Long uplinkDelayMs);

        /**
         * <p>
         * Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
         * </p>
         * 
         * @param downlinkDelayMs
         *        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkDelayMs(Long downlinkDelayMs);

        /**
         * <p>
         * Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
         * </p>
         * 
         * @param uplinkJitterMs
         *        Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uplinkJitterMs(Long uplinkJitterMs);

        /**
         * <p>
         * Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
         * </p>
         * 
         * @param downlinkJitterMs
         *        Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkJitterMs(Long downlinkJitterMs);

        /**
         * <p>
         * Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
         * </p>
         * 
         * @param uplinkLossPercent
         *        Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uplinkLossPercent(Integer uplinkLossPercent);

        /**
         * <p>
         * Proportion of received packets that fail to arrive from 0 to 100 percent.
         * </p>
         * 
         * @param downlinkLossPercent
         *        Proportion of received packets that fail to arrive from 0 to 100 percent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkLossPercent(Integer downlinkLossPercent);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String type;

        private Long uplinkBandwidthBits;

        private Long downlinkBandwidthBits;

        private Long uplinkDelayMs;

        private Long downlinkDelayMs;

        private Long uplinkJitterMs;

        private Long downlinkJitterMs;

        private Integer uplinkLossPercent;

        private Integer downlinkLossPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNetworkProfileRequest model) {
            arn(model.arn);
            name(model.name);
            description(model.description);
            type(model.type);
            uplinkBandwidthBits(model.uplinkBandwidthBits);
            downlinkBandwidthBits(model.downlinkBandwidthBits);
            uplinkDelayMs(model.uplinkDelayMs);
            downlinkDelayMs(model.downlinkDelayMs);
            uplinkJitterMs(model.uplinkJitterMs);
            downlinkJitterMs(model.downlinkJitterMs);
            uplinkLossPercent(model.uplinkLossPercent);
            downlinkLossPercent(model.downlinkLossPercent);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NetworkProfileType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Long getUplinkBandwidthBits() {
            return uplinkBandwidthBits;
        }

        @Override
        public final Builder uplinkBandwidthBits(Long uplinkBandwidthBits) {
            this.uplinkBandwidthBits = uplinkBandwidthBits;
            return this;
        }

        public final void setUplinkBandwidthBits(Long uplinkBandwidthBits) {
            this.uplinkBandwidthBits = uplinkBandwidthBits;
        }

        public final Long getDownlinkBandwidthBits() {
            return downlinkBandwidthBits;
        }

        @Override
        public final Builder downlinkBandwidthBits(Long downlinkBandwidthBits) {
            this.downlinkBandwidthBits = downlinkBandwidthBits;
            return this;
        }

        public final void setDownlinkBandwidthBits(Long downlinkBandwidthBits) {
            this.downlinkBandwidthBits = downlinkBandwidthBits;
        }

        public final Long getUplinkDelayMs() {
            return uplinkDelayMs;
        }

        @Override
        public final Builder uplinkDelayMs(Long uplinkDelayMs) {
            this.uplinkDelayMs = uplinkDelayMs;
            return this;
        }

        public final void setUplinkDelayMs(Long uplinkDelayMs) {
            this.uplinkDelayMs = uplinkDelayMs;
        }

        public final Long getDownlinkDelayMs() {
            return downlinkDelayMs;
        }

        @Override
        public final Builder downlinkDelayMs(Long downlinkDelayMs) {
            this.downlinkDelayMs = downlinkDelayMs;
            return this;
        }

        public final void setDownlinkDelayMs(Long downlinkDelayMs) {
            this.downlinkDelayMs = downlinkDelayMs;
        }

        public final Long getUplinkJitterMs() {
            return uplinkJitterMs;
        }

        @Override
        public final Builder uplinkJitterMs(Long uplinkJitterMs) {
            this.uplinkJitterMs = uplinkJitterMs;
            return this;
        }

        public final void setUplinkJitterMs(Long uplinkJitterMs) {
            this.uplinkJitterMs = uplinkJitterMs;
        }

        public final Long getDownlinkJitterMs() {
            return downlinkJitterMs;
        }

        @Override
        public final Builder downlinkJitterMs(Long downlinkJitterMs) {
            this.downlinkJitterMs = downlinkJitterMs;
            return this;
        }

        public final void setDownlinkJitterMs(Long downlinkJitterMs) {
            this.downlinkJitterMs = downlinkJitterMs;
        }

        public final Integer getUplinkLossPercent() {
            return uplinkLossPercent;
        }

        @Override
        public final Builder uplinkLossPercent(Integer uplinkLossPercent) {
            this.uplinkLossPercent = uplinkLossPercent;
            return this;
        }

        public final void setUplinkLossPercent(Integer uplinkLossPercent) {
            this.uplinkLossPercent = uplinkLossPercent;
        }

        public final Integer getDownlinkLossPercent() {
            return downlinkLossPercent;
        }

        @Override
        public final Builder downlinkLossPercent(Integer downlinkLossPercent) {
            this.downlinkLossPercent = downlinkLossPercent;
            return this;
        }

        public final void setDownlinkLossPercent(Integer downlinkLossPercent) {
            this.downlinkLossPercent = downlinkLossPercent;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateNetworkProfileRequest build() {
            return new UpdateNetworkProfileRequest(this);
        }
    }
}
