/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum UploadType {
    ANDROID_APP("ANDROID_APP"),

    IOS_APP("IOS_APP"),

    WEB_APP("WEB_APP"),

    EXTERNAL_DATA("EXTERNAL_DATA"),

    APPIUM_JAVA_JUNIT_TEST_PACKAGE("APPIUM_JAVA_JUNIT_TEST_PACKAGE"),

    APPIUM_JAVA_TESTNG_TEST_PACKAGE("APPIUM_JAVA_TESTNG_TEST_PACKAGE"),

    APPIUM_PYTHON_TEST_PACKAGE("APPIUM_PYTHON_TEST_PACKAGE"),

    APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE("APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE"),

    APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE("APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE"),

    APPIUM_WEB_PYTHON_TEST_PACKAGE("APPIUM_WEB_PYTHON_TEST_PACKAGE"),

    CALABASH_TEST_PACKAGE("CALABASH_TEST_PACKAGE"),

    INSTRUMENTATION_TEST_PACKAGE("INSTRUMENTATION_TEST_PACKAGE"),

    UIAUTOMATION_TEST_PACKAGE("UIAUTOMATION_TEST_PACKAGE"),

    UIAUTOMATOR_TEST_PACKAGE("UIAUTOMATOR_TEST_PACKAGE"),

    XCTEST_TEST_PACKAGE("XCTEST_TEST_PACKAGE"),

    XCTEST_UI_TEST_PACKAGE("XCTEST_UI_TEST_PACKAGE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private UploadType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return UploadType corresponding to the value
     */
    public static UploadType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(UploadType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link UploadType}s
     */
    public static Set<UploadType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
