/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.Counters;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Counters} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CountersMarshaller {
    private static final MarshallingInfo<Integer> TOTAL_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("total").isBinary(false).build();

    private static final MarshallingInfo<Integer> PASSED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("passed").isBinary(false).build();

    private static final MarshallingInfo<Integer> FAILED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failed").isBinary(false).build();

    private static final MarshallingInfo<Integer> WARNED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("warned").isBinary(false).build();

    private static final MarshallingInfo<Integer> ERRORED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errored").isBinary(false).build();

    private static final MarshallingInfo<Integer> STOPPED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopped").isBinary(false).build();

    private static final MarshallingInfo<Integer> SKIPPED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("skipped").isBinary(false).build();

    private static final CountersMarshaller INSTANCE = new CountersMarshaller();

    private CountersMarshaller() {
    }

    public static CountersMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Counters counters, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(counters, "counters");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(counters.total(), TOTAL_BINDING);
            protocolMarshaller.marshall(counters.passed(), PASSED_BINDING);
            protocolMarshaller.marshall(counters.failed(), FAILED_BINDING);
            protocolMarshaller.marshall(counters.warned(), WARNED_BINDING);
            protocolMarshaller.marshall(counters.errored(), ERRORED_BINDING);
            protocolMarshaller.marshall(counters.stopped(), STOPPED_BINDING);
            protocolMarshaller.marshall(counters.skipped(), SKIPPED_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
