/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link GetDevicePoolCompatibilityRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class GetDevicePoolCompatibilityRequestModelMarshaller {
    private static final MarshallingInfo<String> DEVICEPOOLARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("devicePoolArn").isBinary(false).build();

    private static final MarshallingInfo<String> APPARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("appArn").isBinary(false).build();

    private static final MarshallingInfo<String> TESTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("testType").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> TEST_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("test").isBinary(false).build();

    private static final GetDevicePoolCompatibilityRequestModelMarshaller INSTANCE = new GetDevicePoolCompatibilityRequestModelMarshaller();

    private GetDevicePoolCompatibilityRequestModelMarshaller() {
    }

    public static GetDevicePoolCompatibilityRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(GetDevicePoolCompatibilityRequest getDevicePoolCompatibilityRequest,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(getDevicePoolCompatibilityRequest, "getDevicePoolCompatibilityRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(getDevicePoolCompatibilityRequest.devicePoolArn(), DEVICEPOOLARN_BINDING);
            protocolMarshaller.marshall(getDevicePoolCompatibilityRequest.appArn(), APPARN_BINDING);
            protocolMarshaller.marshall(getDevicePoolCompatibilityRequest.testTypeString(), TESTTYPE_BINDING);
            protocolMarshaller.marshall(getDevicePoolCompatibilityRequest.test(), TEST_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
