/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunConfiguration;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ScheduleRunConfiguration} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ScheduleRunConfigurationMarshaller {
    private static final MarshallingInfo<String> EXTRADATAPACKAGEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("extraDataPackageArn").isBinary(false).build();

    private static final MarshallingInfo<String> NETWORKPROFILEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkProfileArn").isBinary(false).build();

    private static final MarshallingInfo<String> LOCALE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("locale").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CUSTOMERARTIFACTPATHS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("customerArtifactPaths").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> RADIOS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("radios").isBinary(false).build();

    private static final MarshallingInfo<List> AUXILIARYAPPS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("auxiliaryApps").isBinary(false).build();

    private static final MarshallingInfo<String> BILLINGMETHOD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("billingMethod").isBinary(false).build();

    private static final ScheduleRunConfigurationMarshaller INSTANCE = new ScheduleRunConfigurationMarshaller();

    private ScheduleRunConfigurationMarshaller() {
    }

    public static ScheduleRunConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ScheduleRunConfiguration scheduleRunConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(scheduleRunConfiguration, "scheduleRunConfiguration");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(scheduleRunConfiguration.extraDataPackageArn(), EXTRADATAPACKAGEARN_BINDING);
            protocolMarshaller.marshall(scheduleRunConfiguration.networkProfileArn(), NETWORKPROFILEARN_BINDING);
            protocolMarshaller.marshall(scheduleRunConfiguration.locale(), LOCALE_BINDING);
            protocolMarshaller.marshall(scheduleRunConfiguration.location(), LOCATION_BINDING);
            protocolMarshaller.marshall(scheduleRunConfiguration.customerArtifactPaths(), CUSTOMERARTIFACTPATHS_BINDING);
            protocolMarshaller.marshall(scheduleRunConfiguration.radios(), RADIOS_BINDING);
            protocolMarshaller.marshall(scheduleRunConfiguration.auxiliaryApps(), AUXILIARYAPPS_BINDING);
            protocolMarshaller.marshall(scheduleRunConfiguration.billingMethodString(), BILLINGMETHOD_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
