/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.OfferingStatus;
import software.amazon.awssdk.services.devicefarm.model.OfferingStatusMapCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetOfferingStatusResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, GetOfferingStatusResponse> {
    private final Map<String, OfferingStatus> current;
    private final Map<String, OfferingStatus> nextPeriod;
    private final String nextToken;

    private GetOfferingStatusResponse(BuilderImpl builder) {
        super(builder);
        this.current = builder.current;
        this.nextPeriod = builder.nextPeriod;
        this.nextToken = builder.nextToken;
    }

    public Map<String, OfferingStatus> current() {
        return this.current;
    }

    public Map<String, OfferingStatus> nextPeriod() {
        return this.nextPeriod;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.current());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOfferingStatusResponse)) {
            return false;
        }
        GetOfferingStatusResponse other = (GetOfferingStatusResponse)((Object)obj);
        return Objects.equals(this.current(), other.current()) && Objects.equals(this.nextPeriod(), other.nextPeriod()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetOfferingStatusResponse").add("Current", this.current()).add("NextPeriod", this.nextPeriod()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "current": {
                return Optional.of(clazz.cast(this.current()));
            }
            case "nextPeriod": {
                return Optional.of(clazz.cast(this.nextPeriod()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private Map<String, OfferingStatus> current;
        private Map<String, OfferingStatus> nextPeriod;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOfferingStatusResponse model) {
            this.current(model.current);
            this.nextPeriod(model.nextPeriod);
            this.nextToken(model.nextToken);
        }

        public final Map<String, OfferingStatus.Builder> getCurrent() {
            return this.current != null ? CollectionUtils.mapValues(this.current, OfferingStatus::toBuilder) : null;
        }

        @Override
        public final Builder current(Map<String, OfferingStatus> current) {
            this.current = OfferingStatusMapCopier.copy(current);
            return this;
        }

        public final void setCurrent(Map<String, OfferingStatus.BuilderImpl> current) {
            this.current = OfferingStatusMapCopier.copyFromBuilder(current);
        }

        public final Map<String, OfferingStatus.Builder> getNextPeriod() {
            return this.nextPeriod != null ? CollectionUtils.mapValues(this.nextPeriod, OfferingStatus::toBuilder) : null;
        }

        @Override
        public final Builder nextPeriod(Map<String, OfferingStatus> nextPeriod) {
            this.nextPeriod = OfferingStatusMapCopier.copy(nextPeriod);
            return this;
        }

        public final void setNextPeriod(Map<String, OfferingStatus.BuilderImpl> nextPeriod) {
            this.nextPeriod = OfferingStatusMapCopier.copyFromBuilder(nextPeriod);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetOfferingStatusResponse build() {
            return new GetOfferingStatusResponse(this);
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    CopyableBuilder<Builder, GetOfferingStatusResponse> {
        public Builder current(Map<String, OfferingStatus> var1);

        public Builder nextPeriod(Map<String, OfferingStatus> var1);

        public Builder nextToken(String var1);
    }
}

