/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.CurrencyCode;
import software.amazon.awssdk.services.devicefarm.transform.MonetaryAmountMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MonetaryAmount
implements StructuredPojo,
ToCopyableBuilder<Builder, MonetaryAmount> {
    private final Double amount;
    private final String currencyCode;

    private MonetaryAmount(BuilderImpl builder) {
        this.amount = builder.amount;
        this.currencyCode = builder.currencyCode;
    }

    public Double amount() {
        return this.amount;
    }

    public CurrencyCode currencyCode() {
        return CurrencyCode.fromValue(this.currencyCode);
    }

    public String currencyCodeString() {
        return this.currencyCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonetaryAmount)) {
            return false;
        }
        MonetaryAmount other = (MonetaryAmount)obj;
        return Objects.equals(this.amount(), other.amount()) && Objects.equals(this.currencyCodeString(), other.currencyCodeString());
    }

    public String toString() {
        return ToString.builder((String)"MonetaryAmount").add("Amount", (Object)this.amount()).add("CurrencyCode", (Object)this.currencyCodeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amount": {
                return Optional.of(clazz.cast(this.amount()));
            }
            case "currencyCode": {
                return Optional.of(clazz.cast(this.currencyCodeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MonetaryAmountMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Double amount;
        private String currencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(MonetaryAmount model) {
            this.amount(model.amount);
            this.currencyCode(model.currencyCode);
        }

        public final Double getAmount() {
            return this.amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public MonetaryAmount build() {
            return new MonetaryAmount(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MonetaryAmount> {
        public Builder amount(Double var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCode var1);
    }
}

