/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.Device;
import software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse;

public class ListDevicesPublisher
implements SdkPublisher<ListDevicesResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListDevicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDevicesPublisher(DeviceFarmAsyncClient client, ListDevicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDevicesPublisher(DeviceFarmAsyncClient client, ListDevicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDevicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDevicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Device> devices() {
        Function<ListDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.devices() != null) {
                return response.devices().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListDevicesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListDevicesPublisher resume(ListDevicesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDevicesPublisher(this.client, (ListDevicesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListDevicesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListDevicesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListDevicesResponseFetcher
    implements AsyncPageFetcher<ListDevicesResponse> {
        private ListDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListDevicesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListDevicesResponse> nextPage(ListDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListDevicesPublisher.this.client.listDevices(ListDevicesPublisher.this.firstRequest);
            }
            return ListDevicesPublisher.this.client.listDevices((ListDevicesRequest)((Object)ListDevicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

