/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.ListRunsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListRunsResponse;
import software.amazon.awssdk.services.devicefarm.model.Run;

public class ListRunsPublisher
implements SdkPublisher<ListRunsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRunsPublisher(DeviceFarmAsyncClient client, ListRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRunsPublisher(DeviceFarmAsyncClient client, ListRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Run> runs() {
        Function<ListRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.runs() != null) {
                return response.runs().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListRunsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListRunsPublisher resume(ListRunsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListRunsPublisher(this.client, (ListRunsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListRunsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListRunsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListRunsResponseFetcher
    implements AsyncPageFetcher<ListRunsResponse> {
        private ListRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListRunsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListRunsResponse> nextPage(ListRunsResponse previousPage) {
            if (previousPage == null) {
                return ListRunsPublisher.this.client.listRuns(ListRunsPublisher.this.firstRequest);
            }
            return ListRunsPublisher.this.client.listRuns((ListRunsRequest)((Object)ListRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

