/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse;
import software.amazon.awssdk.services.devicefarm.model.Suite;

public class ListSuitesIterable
implements SdkIterable<ListSuitesResponse> {
    private final DeviceFarmClient client;
    private final ListSuitesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSuitesIterable(DeviceFarmClient client, ListSuitesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSuitesResponseFetcher();
    }

    public Iterator<ListSuitesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Suite> suites() {
        Function<ListSuitesResponse, Iterator> getIterator = response -> {
            if (response != null && response.suites() != null) {
                return response.suites().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListSuitesIterable resume(ListSuitesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSuitesIterable(this.client, (ListSuitesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListSuitesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListSuitesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListSuitesResponseFetcher
    implements SyncPageFetcher<ListSuitesResponse> {
        private ListSuitesResponseFetcher() {
        }

        public boolean hasNextPage(ListSuitesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListSuitesResponse nextPage(ListSuitesResponse previousPage) {
            if (previousPage == null) {
                return ListSuitesIterable.this.client.listSuites(ListSuitesIterable.this.firstRequest);
            }
            return ListSuitesIterable.this.client.listSuites((ListSuitesRequest)((Object)ListSuitesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

