/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListTestsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestsResponse;
import software.amazon.awssdk.services.devicefarm.model.Test;

public class ListTestsIterable
implements SdkIterable<ListTestsResponse> {
    private final DeviceFarmClient client;
    private final ListTestsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestsIterable(DeviceFarmClient client, ListTestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTestsResponseFetcher();
    }

    public Iterator<ListTestsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Test> tests() {
        Function<ListTestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tests() != null) {
                return response.tests().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListTestsIterable resume(ListTestsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTestsIterable(this.client, (ListTestsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTestsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListTestsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListTestsResponseFetcher
    implements SyncPageFetcher<ListTestsResponse> {
        private ListTestsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListTestsResponse nextPage(ListTestsResponse previousPage) {
            if (previousPage == null) {
                return ListTestsIterable.this.client.listTests(ListTestsIterable.this.firstRequest);
            }
            return ListTestsIterable.this.client.listTests((ListTestsRequest)((Object)ListTestsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

