/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.ListTestsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestsResponse;
import software.amazon.awssdk.services.devicefarm.model.Test;

public class ListTestsPublisher
implements SdkPublisher<ListTestsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListTestsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestsPublisher(DeviceFarmAsyncClient client, ListTestsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestsPublisher(DeviceFarmAsyncClient client, ListTestsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Test> tests() {
        Function<ListTestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tests() != null) {
                return response.tests().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListTestsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListTestsPublisher resume(ListTestsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTestsPublisher(this.client, (ListTestsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTestsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListTestsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListTestsResponseFetcher
    implements AsyncPageFetcher<ListTestsResponse> {
        private ListTestsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListTestsResponse> nextPage(ListTestsResponse previousPage) {
            if (previousPage == null) {
                return ListTestsPublisher.this.client.listTests(ListTestsPublisher.this.firstRequest);
            }
            return ListTestsPublisher.this.client.listTests((ListTestsRequest)((Object)ListTestsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

