/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse;
import software.amazon.awssdk.services.devicefarm.model.UniqueProblem;

public class ListUniqueProblemsPublisher
implements SdkPublisher<ListUniqueProblemsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListUniqueProblemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUniqueProblemsPublisher(DeviceFarmAsyncClient client, ListUniqueProblemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUniqueProblemsPublisher(DeviceFarmAsyncClient client, ListUniqueProblemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUniqueProblemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUniqueProblemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Map.Entry<String, List<UniqueProblem>>> uniqueProblemsStrings() {
        Function<ListUniqueProblemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.uniqueProblemsStrings() != null) {
                return response.uniqueProblemsStrings().entrySet().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListUniqueProblemsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListUniqueProblemsPublisher resume(ListUniqueProblemsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListUniqueProblemsPublisher(this.client, (ListUniqueProblemsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListUniqueProblemsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListUniqueProblemsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListUniqueProblemsResponseFetcher
    implements AsyncPageFetcher<ListUniqueProblemsResponse> {
        private ListUniqueProblemsResponseFetcher() {
        }

        public boolean hasNextPage(ListUniqueProblemsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListUniqueProblemsResponse> nextPage(ListUniqueProblemsResponse previousPage) {
            if (previousPage == null) {
                return ListUniqueProblemsPublisher.this.client.listUniqueProblems(ListUniqueProblemsPublisher.this.firstRequest);
            }
            return ListUniqueProblemsPublisher.this.client.listUniqueProblems((ListUniqueProblemsRequest)((Object)ListUniqueProblemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

