/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse;
import software.amazon.awssdk.services.devicefarm.model.Upload;

public class ListUploadsPublisher
implements SdkPublisher<ListUploadsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListUploadsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUploadsPublisher(DeviceFarmAsyncClient client, ListUploadsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUploadsPublisher(DeviceFarmAsyncClient client, ListUploadsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUploadsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUploadsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Upload> uploads() {
        Function<ListUploadsResponse, Iterator> getIterator = response -> {
            if (response != null && response.uploads() != null) {
                return response.uploads().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListUploadsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListUploadsPublisher resume(ListUploadsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListUploadsPublisher(this.client, (ListUploadsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListUploadsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListUploadsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListUploadsResponseFetcher
    implements AsyncPageFetcher<ListUploadsResponse> {
        private ListUploadsResponseFetcher() {
        }

        public boolean hasNextPage(ListUploadsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListUploadsResponse> nextPage(ListUploadsResponse previousPage) {
            if (previousPage == null) {
                return ListUploadsPublisher.this.client.listUploads(ListUploadsPublisher.this.firstRequest);
            }
            return ListUploadsPublisher.this.client.listUploads((ListUploadsRequest)((Object)ListUploadsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

