/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.DevicePoolCompatibilityResult;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DevicePoolCompatibilityResultMarshaller {
    private static final MarshallingInfo<StructuredPojo> DEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("device").isBinary(false).build();
    private static final MarshallingInfo<Boolean> COMPATIBLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("compatible").isBinary(false).build();
    private static final MarshallingInfo<List> INCOMPATIBILITYMESSAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("incompatibilityMessages").isBinary(false).build();
    private static final DevicePoolCompatibilityResultMarshaller INSTANCE = new DevicePoolCompatibilityResultMarshaller();

    private DevicePoolCompatibilityResultMarshaller() {
    }

    public static DevicePoolCompatibilityResultMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DevicePoolCompatibilityResult devicePoolCompatibilityResult, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)devicePoolCompatibilityResult, (String)"devicePoolCompatibilityResult");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)devicePoolCompatibilityResult.device(), DEVICE_BINDING);
            protocolMarshaller.marshall((Object)devicePoolCompatibilityResult.compatible(), COMPATIBLE_BINDING);
            protocolMarshaller.marshall(devicePoolCompatibilityResult.incompatibilityMessages(), INCOMPATIBILITYMESSAGES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

