/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.RenewOfferingRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RenewOfferingRequestModelMarshaller {
    private static final MarshallingInfo<String> OFFERINGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("offeringId").isBinary(false).build();
    private static final MarshallingInfo<Integer> QUANTITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("quantity").isBinary(false).build();
    private static final RenewOfferingRequestModelMarshaller INSTANCE = new RenewOfferingRequestModelMarshaller();

    private RenewOfferingRequestModelMarshaller() {
    }

    public static RenewOfferingRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RenewOfferingRequest renewOfferingRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)renewOfferingRequest), (String)"renewOfferingRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)renewOfferingRequest.offeringId(), OFFERINGID_BINDING);
            protocolMarshaller.marshall((Object)renewOfferingRequest.quantity(), QUANTITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

