/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.Resolution;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResolutionMarshaller {
    private static final MarshallingInfo<Integer> WIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("width").isBinary(false).build();
    private static final MarshallingInfo<Integer> HEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("height").isBinary(false).build();
    private static final ResolutionMarshaller INSTANCE = new ResolutionMarshaller();

    private ResolutionMarshaller() {
    }

    public static ResolutionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Resolution resolution, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resolution, (String)"resolution");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resolution.width(), WIDTH_BINDING);
            protocolMarshaller.marshall((Object)resolution.height(), HEIGHT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

