/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the total (metered or unmetered) minutes used by the resource to run tests. Contains the sum of minutes
 * consumed by all children.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceMinutes implements SdkPojo, Serializable, ToCopyableBuilder<DeviceMinutes.Builder, DeviceMinutes> {
    private static final SdkField<Double> TOTAL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(DeviceMinutes::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final SdkField<Double> METERED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(DeviceMinutes::metered)).setter(setter(Builder::metered))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metered").build()).build();

    private static final SdkField<Double> UNMETERED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(DeviceMinutes::unmetered)).setter(setter(Builder::unmetered))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unmetered").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FIELD, METERED_FIELD,
            UNMETERED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double total;

    private final Double metered;

    private final Double unmetered;

    private DeviceMinutes(BuilderImpl builder) {
        this.total = builder.total;
        this.metered = builder.metered;
        this.unmetered = builder.unmetered;
    }

    /**
     * <p>
     * When specified, represents the total minutes used by the resource to run tests.
     * </p>
     * 
     * @return When specified, represents the total minutes used by the resource to run tests.
     */
    public Double total() {
        return total;
    }

    /**
     * <p>
     * When specified, represents only the sum of metered minutes used by the resource to run tests.
     * </p>
     * 
     * @return When specified, represents only the sum of metered minutes used by the resource to run tests.
     */
    public Double metered() {
        return metered;
    }

    /**
     * <p>
     * When specified, represents only the sum of unmetered minutes used by the resource to run tests.
     * </p>
     * 
     * @return When specified, represents only the sum of unmetered minutes used by the resource to run tests.
     */
    public Double unmetered() {
        return unmetered;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(metered());
        hashCode = 31 * hashCode + Objects.hashCode(unmetered());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceMinutes)) {
            return false;
        }
        DeviceMinutes other = (DeviceMinutes) obj;
        return Objects.equals(total(), other.total()) && Objects.equals(metered(), other.metered())
                && Objects.equals(unmetered(), other.unmetered());
    }

    @Override
    public String toString() {
        return ToString.builder("DeviceMinutes").add("Total", total()).add("Metered", metered()).add("Unmetered", unmetered())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "total":
            return Optional.ofNullable(clazz.cast(total()));
        case "metered":
            return Optional.ofNullable(clazz.cast(metered()));
        case "unmetered":
            return Optional.ofNullable(clazz.cast(unmetered()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceMinutes, T> g) {
        return obj -> g.apply((DeviceMinutes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceMinutes> {
        /**
         * <p>
         * When specified, represents the total minutes used by the resource to run tests.
         * </p>
         * 
         * @param total
         *        When specified, represents the total minutes used by the resource to run tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Double total);

        /**
         * <p>
         * When specified, represents only the sum of metered minutes used by the resource to run tests.
         * </p>
         * 
         * @param metered
         *        When specified, represents only the sum of metered minutes used by the resource to run tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metered(Double metered);

        /**
         * <p>
         * When specified, represents only the sum of unmetered minutes used by the resource to run tests.
         * </p>
         * 
         * @param unmetered
         *        When specified, represents only the sum of unmetered minutes used by the resource to run tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unmetered(Double unmetered);
    }

    static final class BuilderImpl implements Builder {
        private Double total;

        private Double metered;

        private Double unmetered;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceMinutes model) {
            total(model.total);
            metered(model.metered);
            unmetered(model.unmetered);
        }

        public final Double getTotal() {
            return total;
        }

        @Override
        public final Builder total(Double total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Double total) {
            this.total = total;
        }

        public final Double getMetered() {
            return metered;
        }

        @Override
        public final Builder metered(Double metered) {
            this.metered = metered;
            return this;
        }

        public final void setMetered(Double metered) {
            this.metered = metered;
        }

        public final Double getUnmetered() {
            return unmetered;
        }

        @Override
        public final Builder unmetered(Double unmetered) {
            this.unmetered = unmetered;
            return this;
        }

        public final void setUnmetered(Double unmetered) {
            this.unmetered = unmetered;
        }

        @Override
        public DeviceMinutes build() {
            return new DeviceMinutes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
