/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to the update project operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProjectRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<UpdateProjectRequest.Builder, UpdateProjectRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProjectRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProjectRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> DEFAULT_JOB_TIMEOUT_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(UpdateProjectRequest::defaultJobTimeoutMinutes))
            .setter(setter(Builder::defaultJobTimeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultJobTimeoutMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DEFAULT_JOB_TIMEOUT_MINUTES_FIELD));

    private final String arn;

    private final String name;

    private final Integer defaultJobTimeoutMinutes;

    private UpdateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.defaultJobTimeoutMinutes = builder.defaultJobTimeoutMinutes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project whose name you wish to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project whose name you wish to update.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * A string representing the new name of the project that you are updating.
     * </p>
     * 
     * @return A string representing the new name of the project that you are updating.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The number of minutes a test run in the project will execute before it times out.
     * </p>
     * 
     * @return The number of minutes a test run in the project will execute before it times out.
     */
    public Integer defaultJobTimeoutMinutes() {
        return defaultJobTimeoutMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(defaultJobTimeoutMinutes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectRequest)) {
            return false;
        }
        UpdateProjectRequest other = (UpdateProjectRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(defaultJobTimeoutMinutes(), other.defaultJobTimeoutMinutes());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateProjectRequest").add("Arn", arn()).add("Name", name())
                .add("DefaultJobTimeoutMinutes", defaultJobTimeoutMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "defaultJobTimeoutMinutes":
            return Optional.ofNullable(clazz.cast(defaultJobTimeoutMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectRequest, T> g) {
        return obj -> g.apply((UpdateProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProjectRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project whose name you wish to update.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the project whose name you wish to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A string representing the new name of the project that you are updating.
         * </p>
         * 
         * @param name
         *        A string representing the new name of the project that you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The number of minutes a test run in the project will execute before it times out.
         * </p>
         * 
         * @param defaultJobTimeoutMinutes
         *        The number of minutes a test run in the project will execute before it times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private Integer defaultJobTimeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectRequest model) {
            super(model);
            arn(model.arn);
            name(model.name);
            defaultJobTimeoutMinutes(model.defaultJobTimeoutMinutes);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getDefaultJobTimeoutMinutes() {
            return defaultJobTimeoutMinutes;
        }

        @Override
        public final Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
            return this;
        }

        public final void setDefaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProjectRequest build() {
            return new UpdateProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
