/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about incompatibility.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncompatibilityMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<IncompatibilityMessage.Builder, IncompatibilityMessage> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IncompatibilityMessage::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IncompatibilityMessage::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String message;

    private final String type;

    private IncompatibilityMessage(BuilderImpl builder) {
        this.message = builder.message;
        this.type = builder.type;
    }

    /**
     * <p>
     * A message about the incompatibility.
     * </p>
     * 
     * @return A message about the incompatibility.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The type of incompatibility.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ARN: The ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * FORM_FACTOR: The form factor (for example, phone or tablet).
     * </p>
     * </li>
     * <li>
     * <p>
     * MANUFACTURER: The manufacturer.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM: The platform (for example, Android or iOS).
     * </p>
     * </li>
     * <li>
     * <p>
     * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_VERSION: The Appium version for the test.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeviceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of incompatibility.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ARN: The ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FORM_FACTOR: The form factor (for example, phone or tablet).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MANUFACTURER: The manufacturer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM: The platform (for example, Android or iOS).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_VERSION: The Appium version for the test.
     *         </p>
     *         </li>
     * @see DeviceAttribute
     */
    public DeviceAttribute type() {
        return DeviceAttribute.fromValue(type);
    }

    /**
     * <p>
     * The type of incompatibility.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ARN: The ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * FORM_FACTOR: The form factor (for example, phone or tablet).
     * </p>
     * </li>
     * <li>
     * <p>
     * MANUFACTURER: The manufacturer.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM: The platform (for example, Android or iOS).
     * </p>
     * </li>
     * <li>
     * <p>
     * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_VERSION: The Appium version for the test.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeviceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of incompatibility.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ARN: The ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FORM_FACTOR: The form factor (for example, phone or tablet).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MANUFACTURER: The manufacturer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM: The platform (for example, Android or iOS).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_VERSION: The Appium version for the test.
     *         </p>
     *         </li>
     * @see DeviceAttribute
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncompatibilityMessage)) {
            return false;
        }
        IncompatibilityMessage other = (IncompatibilityMessage) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("IncompatibilityMessage").add("Message", message()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IncompatibilityMessage, T> g) {
        return obj -> g.apply((IncompatibilityMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IncompatibilityMessage> {
        /**
         * <p>
         * A message about the incompatibility.
         * </p>
         * 
         * @param message
         *        A message about the incompatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The type of incompatibility.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ARN: The ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORM_FACTOR: The form factor (for example, phone or tablet).
         * </p>
         * </li>
         * <li>
         * <p>
         * MANUFACTURER: The manufacturer.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM: The platform (for example, Android or iOS).
         * </p>
         * </li>
         * <li>
         * <p>
         * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_VERSION: The Appium version for the test.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of incompatibility.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ARN: The ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORM_FACTOR: The form factor (for example, phone or tablet).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MANUFACTURER: The manufacturer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM: The platform (for example, Android or iOS).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_VERSION: The Appium version for the test.
         *        </p>
         *        </li>
         * @see DeviceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAttribute
         */
        Builder type(String type);

        /**
         * <p>
         * The type of incompatibility.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ARN: The ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORM_FACTOR: The form factor (for example, phone or tablet).
         * </p>
         * </li>
         * <li>
         * <p>
         * MANUFACTURER: The manufacturer.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM: The platform (for example, Android or iOS).
         * </p>
         * </li>
         * <li>
         * <p>
         * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_VERSION: The Appium version for the test.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of incompatibility.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ARN: The ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORM_FACTOR: The form factor (for example, phone or tablet).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MANUFACTURER: The manufacturer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM: The platform (for example, Android or iOS).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_VERSION: The Appium version for the test.
         *        </p>
         *        </li>
         * @see DeviceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAttribute
         */
        Builder type(DeviceAttribute type);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(IncompatibilityMessage model) {
            message(model.message);
            type(model.type);
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DeviceAttribute type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public IncompatibilityMessage build() {
            return new IncompatibilityMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
