/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the metadata of an offering transaction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OfferingTransaction implements SdkPojo, Serializable,
        ToCopyableBuilder<OfferingTransaction.Builder, OfferingTransaction> {
    private static final SdkField<OfferingStatus> OFFERING_STATUS_FIELD = SdkField
            .<OfferingStatus> builder(MarshallingType.SDK_POJO).getter(getter(OfferingTransaction::offeringStatus))
            .setter(setter(Builder::offeringStatus)).constructor(OfferingStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringStatus").build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OfferingTransaction::transactionId)).setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionId").build()).build();

    private static final SdkField<String> OFFERING_PROMOTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OfferingTransaction::offeringPromotionId)).setter(setter(Builder::offeringPromotionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringPromotionId").build())
            .build();

    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(OfferingTransaction::createdOn)).setter(setter(Builder::createdOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdOn").build()).build();

    private static final SdkField<MonetaryAmount> COST_FIELD = SdkField.<MonetaryAmount> builder(MarshallingType.SDK_POJO)
            .getter(getter(OfferingTransaction::cost)).setter(setter(Builder::cost)).constructor(MonetaryAmount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cost").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_STATUS_FIELD,
            TRANSACTION_ID_FIELD, OFFERING_PROMOTION_ID_FIELD, CREATED_ON_FIELD, COST_FIELD));

    private static final long serialVersionUID = 1L;

    private final OfferingStatus offeringStatus;

    private final String transactionId;

    private final String offeringPromotionId;

    private final Instant createdOn;

    private final MonetaryAmount cost;

    private OfferingTransaction(BuilderImpl builder) {
        this.offeringStatus = builder.offeringStatus;
        this.transactionId = builder.transactionId;
        this.offeringPromotionId = builder.offeringPromotionId;
        this.createdOn = builder.createdOn;
        this.cost = builder.cost;
    }

    /**
     * <p>
     * The status of an offering transaction.
     * </p>
     * 
     * @return The status of an offering transaction.
     */
    public OfferingStatus offeringStatus() {
        return offeringStatus;
    }

    /**
     * <p>
     * The transaction ID of the offering transaction.
     * </p>
     * 
     * @return The transaction ID of the offering transaction.
     */
    public String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * The ID that corresponds to a device offering promotion.
     * </p>
     * 
     * @return The ID that corresponds to a device offering promotion.
     */
    public String offeringPromotionId() {
        return offeringPromotionId;
    }

    /**
     * <p>
     * The date on which an offering transaction was created.
     * </p>
     * 
     * @return The date on which an offering transaction was created.
     */
    public Instant createdOn() {
        return createdOn;
    }

    /**
     * <p>
     * The cost of an offering transaction.
     * </p>
     * 
     * @return The cost of an offering transaction.
     */
    public MonetaryAmount cost() {
        return cost;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(offeringStatus());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(offeringPromotionId());
        hashCode = 31 * hashCode + Objects.hashCode(createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(cost());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferingTransaction)) {
            return false;
        }
        OfferingTransaction other = (OfferingTransaction) obj;
        return Objects.equals(offeringStatus(), other.offeringStatus()) && Objects.equals(transactionId(), other.transactionId())
                && Objects.equals(offeringPromotionId(), other.offeringPromotionId())
                && Objects.equals(createdOn(), other.createdOn()) && Objects.equals(cost(), other.cost());
    }

    @Override
    public String toString() {
        return ToString.builder("OfferingTransaction").add("OfferingStatus", offeringStatus())
                .add("TransactionId", transactionId()).add("OfferingPromotionId", offeringPromotionId())
                .add("CreatedOn", createdOn()).add("Cost", cost()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringStatus":
            return Optional.ofNullable(clazz.cast(offeringStatus()));
        case "transactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "offeringPromotionId":
            return Optional.ofNullable(clazz.cast(offeringPromotionId()));
        case "createdOn":
            return Optional.ofNullable(clazz.cast(createdOn()));
        case "cost":
            return Optional.ofNullable(clazz.cast(cost()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OfferingTransaction, T> g) {
        return obj -> g.apply((OfferingTransaction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OfferingTransaction> {
        /**
         * <p>
         * The status of an offering transaction.
         * </p>
         * 
         * @param offeringStatus
         *        The status of an offering transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringStatus(OfferingStatus offeringStatus);

        /**
         * <p>
         * The status of an offering transaction.
         * </p>
         * This is a convenience that creates an instance of the {@link OfferingStatus.Builder} avoiding the need to
         * create one manually via {@link OfferingStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link OfferingStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #offeringStatus(OfferingStatus)}.
         * 
         * @param offeringStatus
         *        a consumer that will call methods on {@link OfferingStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offeringStatus(OfferingStatus)
         */
        default Builder offeringStatus(Consumer<OfferingStatus.Builder> offeringStatus) {
            return offeringStatus(OfferingStatus.builder().applyMutation(offeringStatus).build());
        }

        /**
         * <p>
         * The transaction ID of the offering transaction.
         * </p>
         * 
         * @param transactionId
         *        The transaction ID of the offering transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * The ID that corresponds to a device offering promotion.
         * </p>
         * 
         * @param offeringPromotionId
         *        The ID that corresponds to a device offering promotion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringPromotionId(String offeringPromotionId);

        /**
         * <p>
         * The date on which an offering transaction was created.
         * </p>
         * 
         * @param createdOn
         *        The date on which an offering transaction was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdOn(Instant createdOn);

        /**
         * <p>
         * The cost of an offering transaction.
         * </p>
         * 
         * @param cost
         *        The cost of an offering transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cost(MonetaryAmount cost);

        /**
         * <p>
         * The cost of an offering transaction.
         * </p>
         * This is a convenience that creates an instance of the {@link MonetaryAmount.Builder} avoiding the need to
         * create one manually via {@link MonetaryAmount#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonetaryAmount.Builder#build()} is called immediately and its
         * result is passed to {@link #cost(MonetaryAmount)}.
         * 
         * @param cost
         *        a consumer that will call methods on {@link MonetaryAmount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cost(MonetaryAmount)
         */
        default Builder cost(Consumer<MonetaryAmount.Builder> cost) {
            return cost(MonetaryAmount.builder().applyMutation(cost).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OfferingStatus offeringStatus;

        private String transactionId;

        private String offeringPromotionId;

        private Instant createdOn;

        private MonetaryAmount cost;

        private BuilderImpl() {
        }

        private BuilderImpl(OfferingTransaction model) {
            offeringStatus(model.offeringStatus);
            transactionId(model.transactionId);
            offeringPromotionId(model.offeringPromotionId);
            createdOn(model.createdOn);
            cost(model.cost);
        }

        public final OfferingStatus.Builder getOfferingStatus() {
            return offeringStatus != null ? offeringStatus.toBuilder() : null;
        }

        @Override
        public final Builder offeringStatus(OfferingStatus offeringStatus) {
            this.offeringStatus = offeringStatus;
            return this;
        }

        public final void setOfferingStatus(OfferingStatus.BuilderImpl offeringStatus) {
            this.offeringStatus = offeringStatus != null ? offeringStatus.build() : null;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        public final String getOfferingPromotionId() {
            return offeringPromotionId;
        }

        @Override
        public final Builder offeringPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
            return this;
        }

        public final void setOfferingPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
        }

        public final Instant getCreatedOn() {
            return createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        public final MonetaryAmount.Builder getCost() {
            return cost != null ? cost.toBuilder() : null;
        }

        @Override
        public final Builder cost(MonetaryAmount cost) {
            this.cost = cost;
            return this;
        }

        public final void setCost(MonetaryAmount.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        @Override
        public OfferingTransaction build() {
            return new OfferingTransaction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
