/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server that describes the remote access session when AWS Device Farm stops the
 * session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopRemoteAccessSessionResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<StopRemoteAccessSessionResponse.Builder, StopRemoteAccessSessionResponse> {
    private static final SdkField<RemoteAccessSession> REMOTE_ACCESS_SESSION_FIELD = SdkField
            .<RemoteAccessSession> builder(MarshallingType.SDK_POJO)
            .getter(getter(StopRemoteAccessSessionResponse::remoteAccessSession)).setter(setter(Builder::remoteAccessSession))
            .constructor(RemoteAccessSession::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccessSession").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOTE_ACCESS_SESSION_FIELD));

    private final RemoteAccessSession remoteAccessSession;

    private StopRemoteAccessSessionResponse(BuilderImpl builder) {
        super(builder);
        this.remoteAccessSession = builder.remoteAccessSession;
    }

    /**
     * <p>
     * A container representing the metadata from the service about the remote access session you are stopping.
     * </p>
     * 
     * @return A container representing the metadata from the service about the remote access session you are stopping.
     */
    public RemoteAccessSession remoteAccessSession() {
        return remoteAccessSession;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(remoteAccessSession());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopRemoteAccessSessionResponse)) {
            return false;
        }
        StopRemoteAccessSessionResponse other = (StopRemoteAccessSessionResponse) obj;
        return Objects.equals(remoteAccessSession(), other.remoteAccessSession());
    }

    @Override
    public String toString() {
        return ToString.builder("StopRemoteAccessSessionResponse").add("RemoteAccessSession", remoteAccessSession()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "remoteAccessSession":
            return Optional.ofNullable(clazz.cast(remoteAccessSession()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopRemoteAccessSessionResponse, T> g) {
        return obj -> g.apply((StopRemoteAccessSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StopRemoteAccessSessionResponse> {
        /**
         * <p>
         * A container representing the metadata from the service about the remote access session you are stopping.
         * </p>
         * 
         * @param remoteAccessSession
         *        A container representing the metadata from the service about the remote access session you are
         *        stopping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessSession(RemoteAccessSession remoteAccessSession);

        /**
         * <p>
         * A container representing the metadata from the service about the remote access session you are stopping.
         * </p>
         * This is a convenience that creates an instance of the {@link RemoteAccessSession.Builder} avoiding the need
         * to create one manually via {@link RemoteAccessSession#builder()}.
         *
         * When the {@link Consumer} completes, {@link RemoteAccessSession.Builder#build()} is called immediately and
         * its result is passed to {@link #remoteAccessSession(RemoteAccessSession)}.
         * 
         * @param remoteAccessSession
         *        a consumer that will call methods on {@link RemoteAccessSession.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteAccessSession(RemoteAccessSession)
         */
        default Builder remoteAccessSession(Consumer<RemoteAccessSession.Builder> remoteAccessSession) {
            return remoteAccessSession(RemoteAccessSession.builder().applyMutation(remoteAccessSession).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private RemoteAccessSession remoteAccessSession;

        private BuilderImpl() {
        }

        private BuilderImpl(StopRemoteAccessSessionResponse model) {
            super(model);
            remoteAccessSession(model.remoteAccessSession);
        }

        public final RemoteAccessSession.Builder getRemoteAccessSession() {
            return remoteAccessSession != null ? remoteAccessSession.toBuilder() : null;
        }

        @Override
        public final Builder remoteAccessSession(RemoteAccessSession remoteAccessSession) {
            this.remoteAccessSession = remoteAccessSession;
            return this;
        }

        public final void setRemoteAccessSession(RemoteAccessSession.BuilderImpl remoteAccessSession) {
            this.remoteAccessSession = remoteAccessSession != null ? remoteAccessSession.build() : null;
        }

        @Override
        public StopRemoteAccessSessionResponse build() {
            return new StopRemoteAccessSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
