/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An app or a set of one or more tests to upload or that have been uploaded.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Upload implements SdkPojo, Serializable, ToCopyableBuilder<Upload.Builder, Upload> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Upload::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Upload::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Upload::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Upload::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Upload::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Upload::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Upload::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Upload::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Upload::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Upload::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ARN_FIELD, NAME_FIELD, CREATED_FIELD, TYPE_FIELD, STATUS_FIELD, URL_FIELD, METADATA_FIELD,
                    CONTENT_TYPE_FIELD, MESSAGE_FIELD, CATEGORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final Instant created;

    private final String type;

    private final String status;

    private final String url;

    private final String metadata;

    private final String contentType;

    private final String message;

    private final String category;

    private Upload(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.created = builder.created;
        this.type = builder.type;
        this.status = builder.status;
        this.url = builder.url;
        this.metadata = builder.metadata;
        this.contentType = builder.contentType;
        this.message = builder.message;
        this.category = builder.category;
    }

    /**
     * <p>
     * The upload's ARN.
     * </p>
     * 
     * @return The upload's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The upload's file name.
     * </p>
     * 
     * @return The upload's file name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * When the upload was created.
     * </p>
     * 
     * @return When the upload was created.
     */
    public Instant created() {
        return created;
    }

    /**
     * <p>
     * The upload's type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ANDROID_APP: An Android upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * IOS_APP: An iOS upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * WEB_APP: A web appliction upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXTERNAL_DATA: An external data upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_TEST_PACKAGE: A Calabash test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_TEST_PACKAGE: An XCode test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UploadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The upload's type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ANDROID_APP: An Android upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IOS_APP: An iOS upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WEB_APP: A web appliction upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXTERNAL_DATA: An external data upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_TEST_PACKAGE: A Calabash test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_TEST_PACKAGE: An XCode test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
     *         </p>
     *         </li>
     * @see UploadType
     */
    public UploadType type() {
        return UploadType.fromValue(type);
    }

    /**
     * <p>
     * The upload's type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ANDROID_APP: An Android upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * IOS_APP: An iOS upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * WEB_APP: A web appliction upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXTERNAL_DATA: An external data upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_TEST_PACKAGE: A Calabash test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_TEST_PACKAGE: An XCode test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UploadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The upload's type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ANDROID_APP: An Android upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IOS_APP: An iOS upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WEB_APP: A web appliction upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXTERNAL_DATA: An external data upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_TEST_PACKAGE: A Calabash test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_TEST_PACKAGE: An XCode test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
     *         </p>
     *         </li>
     * @see UploadType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The upload's status.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * FAILED: A failed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * INITIALIZED: An initialized status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING: A processing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUCCEEDED: A succeeded status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UploadStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The upload's status.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         FAILED: A failed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INITIALIZED: An initialized status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING: A processing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SUCCEEDED: A succeeded status.
     *         </p>
     *         </li>
     * @see UploadStatus
     */
    public UploadStatus status() {
        return UploadStatus.fromValue(status);
    }

    /**
     * <p>
     * The upload's status.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * FAILED: A failed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * INITIALIZED: An initialized status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING: A processing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUCCEEDED: A succeeded status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UploadStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The upload's status.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         FAILED: A failed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INITIALIZED: An initialized status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING: A processing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SUCCEEDED: A succeeded status.
     *         </p>
     *         </li>
     * @see UploadStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT request.
     * </p>
     * 
     * @return The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT request.
     */
    public String url() {
        return url;
    }

    /**
     * <p>
     * The upload's metadata. For example, for Android, this contains information that is parsed from the manifest and
     * is displayed in the AWS Device Farm console after the associated app is uploaded.
     * </p>
     * 
     * @return The upload's metadata. For example, for Android, this contains information that is parsed from the
     *         manifest and is displayed in the AWS Device Farm console after the associated app is uploaded.
     */
    public String metadata() {
        return metadata;
    }

    /**
     * <p>
     * The upload's content type (for example, "application/octet-stream").
     * </p>
     * 
     * @return The upload's content type (for example, "application/octet-stream").
     */
    public String contentType() {
        return contentType;
    }

    /**
     * <p>
     * A message about the upload's result.
     * </p>
     * 
     * @return A message about the upload's result.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The upload's category. Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CURATED: An upload managed by AWS Device Farm.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRIVATE: An upload managed by the AWS Device Farm customer.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link UploadCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The upload's category. Allowed values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CURATED: An upload managed by AWS Device Farm.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRIVATE: An upload managed by the AWS Device Farm customer.
     *         </p>
     *         </li>
     * @see UploadCategory
     */
    public UploadCategory category() {
        return UploadCategory.fromValue(category);
    }

    /**
     * <p>
     * The upload's category. Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CURATED: An upload managed by AWS Device Farm.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRIVATE: An upload managed by the AWS Device Farm customer.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link UploadCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The upload's category. Allowed values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CURATED: An upload managed by AWS Device Farm.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRIVATE: An upload managed by the AWS Device Farm customer.
     *         </p>
     *         </li>
     * @see UploadCategory
     */
    public String categoryAsString() {
        return category;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Upload)) {
            return false;
        }
        Upload other = (Upload) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(created(), other.created()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(url(), other.url())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(message(), other.message()) && Objects.equals(categoryAsString(), other.categoryAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("Upload").add("Arn", arn()).add("Name", name()).add("Created", created())
                .add("Type", typeAsString()).add("Status", statusAsString()).add("Url", url()).add("Metadata", metadata())
                .add("ContentType", contentType()).add("Message", message()).add("Category", categoryAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Upload, T> g) {
        return obj -> g.apply((Upload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Upload> {
        /**
         * <p>
         * The upload's ARN.
         * </p>
         * 
         * @param arn
         *        The upload's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The upload's file name.
         * </p>
         * 
         * @param name
         *        The upload's file name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * When the upload was created.
         * </p>
         * 
         * @param created
         *        When the upload was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The upload's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID_APP: An Android upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS_APP: An iOS upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * WEB_APP: A web appliction upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXTERNAL_DATA: An external data upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_TEST_PACKAGE: A Calabash test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_TEST_PACKAGE: An XCode test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The upload's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID_APP: An Android upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS_APP: An iOS upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WEB_APP: A web appliction upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXTERNAL_DATA: An external data upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_TEST_PACKAGE: A Calabash test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_TEST_PACKAGE: An XCode test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
         *        </p>
         *        </li>
         * @see UploadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadType
         */
        Builder type(String type);

        /**
         * <p>
         * The upload's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID_APP: An Android upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS_APP: An iOS upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * WEB_APP: A web appliction upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXTERNAL_DATA: An external data upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_TEST_PACKAGE: A Calabash test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_TEST_PACKAGE: An XCode test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The upload's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID_APP: An Android upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS_APP: An iOS upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WEB_APP: A web appliction upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXTERNAL_DATA: An external data upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_TEST_PACKAGE: A Calabash test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_TEST_PACKAGE: An XCode test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
         *        </p>
         *        </li>
         * @see UploadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadType
         */
        Builder type(UploadType type);

        /**
         * <p>
         * The upload's status.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * FAILED: A failed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * INITIALIZED: An initialized status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SUCCEEDED: A succeeded status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The upload's status.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        FAILED: A failed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INITIALIZED: An initialized status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SUCCEEDED: A succeeded status.
         *        </p>
         *        </li>
         * @see UploadStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The upload's status.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * FAILED: A failed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * INITIALIZED: An initialized status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SUCCEEDED: A succeeded status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The upload's status.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        FAILED: A failed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INITIALIZED: An initialized status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SUCCEEDED: A succeeded status.
         *        </p>
         *        </li>
         * @see UploadStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadStatus
         */
        Builder status(UploadStatus status);

        /**
         * <p>
         * The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT request.
         * </p>
         * 
         * @param url
         *        The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The upload's metadata. For example, for Android, this contains information that is parsed from the manifest
         * and is displayed in the AWS Device Farm console after the associated app is uploaded.
         * </p>
         * 
         * @param metadata
         *        The upload's metadata. For example, for Android, this contains information that is parsed from the
         *        manifest and is displayed in the AWS Device Farm console after the associated app is uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * The upload's content type (for example, "application/octet-stream").
         * </p>
         * 
         * @param contentType
         *        The upload's content type (for example, "application/octet-stream").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * A message about the upload's result.
         * </p>
         * 
         * @param message
         *        A message about the upload's result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The upload's category. Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CURATED: An upload managed by AWS Device Farm.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRIVATE: An upload managed by the AWS Device Farm customer.
         * </p>
         * </li>
         * </ul>
         * 
         * @param category
         *        The upload's category. Allowed values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CURATED: An upload managed by AWS Device Farm.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRIVATE: An upload managed by the AWS Device Farm customer.
         *        </p>
         *        </li>
         * @see UploadCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadCategory
         */
        Builder category(String category);

        /**
         * <p>
         * The upload's category. Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CURATED: An upload managed by AWS Device Farm.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRIVATE: An upload managed by the AWS Device Farm customer.
         * </p>
         * </li>
         * </ul>
         * 
         * @param category
         *        The upload's category. Allowed values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CURATED: An upload managed by AWS Device Farm.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRIVATE: An upload managed by the AWS Device Farm customer.
         *        </p>
         *        </li>
         * @see UploadCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadCategory
         */
        Builder category(UploadCategory category);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private Instant created;

        private String type;

        private String status;

        private String url;

        private String metadata;

        private String contentType;

        private String message;

        private String category;

        private BuilderImpl() {
        }

        private BuilderImpl(Upload model) {
            arn(model.arn);
            name(model.name);
            created(model.created);
            type(model.type);
            status(model.status);
            url(model.url);
            metadata(model.metadata);
            contentType(model.contentType);
            message(model.message);
            category(model.category);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreated() {
            return created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UploadType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UploadStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getMetadata() {
            return metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getCategory() {
            return category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(UploadCategory category) {
            this.category(category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public Upload build() {
            return new Upload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
