/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDeviceInstanceResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<UpdateDeviceInstanceResponse.Builder, UpdateDeviceInstanceResponse> {
    private static final SdkField<DeviceInstance> DEVICE_INSTANCE_FIELD = SdkField
            .<DeviceInstance> builder(MarshallingType.SDK_POJO).getter(getter(UpdateDeviceInstanceResponse::deviceInstance))
            .setter(setter(Builder::deviceInstance)).constructor(DeviceInstance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceInstance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_INSTANCE_FIELD));

    private final DeviceInstance deviceInstance;

    private UpdateDeviceInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.deviceInstance = builder.deviceInstance;
    }

    /**
     * <p>
     * An object containing information about your device instance.
     * </p>
     * 
     * @return An object containing information about your device instance.
     */
    public DeviceInstance deviceInstance() {
        return deviceInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceInstance());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeviceInstanceResponse)) {
            return false;
        }
        UpdateDeviceInstanceResponse other = (UpdateDeviceInstanceResponse) obj;
        return Objects.equals(deviceInstance(), other.deviceInstance());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateDeviceInstanceResponse").add("DeviceInstance", deviceInstance()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceInstance":
            return Optional.ofNullable(clazz.cast(deviceInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeviceInstanceResponse, T> g) {
        return obj -> g.apply((UpdateDeviceInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDeviceInstanceResponse> {
        /**
         * <p>
         * An object containing information about your device instance.
         * </p>
         * 
         * @param deviceInstance
         *        An object containing information about your device instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceInstance(DeviceInstance deviceInstance);

        /**
         * <p>
         * An object containing information about your device instance.
         * </p>
         * This is a convenience that creates an instance of the {@link DeviceInstance.Builder} avoiding the need to
         * create one manually via {@link DeviceInstance#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceInstance.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceInstance(DeviceInstance)}.
         * 
         * @param deviceInstance
         *        a consumer that will call methods on {@link DeviceInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceInstance(DeviceInstance)
         */
        default Builder deviceInstance(Consumer<DeviceInstance.Builder> deviceInstance) {
            return deviceInstance(DeviceInstance.builder().applyMutation(deviceInstance).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private DeviceInstance deviceInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeviceInstanceResponse model) {
            super(model);
            deviceInstance(model.deviceInstance);
        }

        public final DeviceInstance.Builder getDeviceInstance() {
            return deviceInstance != null ? deviceInstance.toBuilder() : null;
        }

        @Override
        public final Builder deviceInstance(DeviceInstance deviceInstance) {
            this.deviceInstance = deviceInstance;
            return this;
        }

        public final void setDeviceInstance(DeviceInstance.BuilderImpl deviceInstance) {
            this.deviceInstance = deviceInstance != null ? deviceInstance.build() : null;
        }

        @Override
        public UpdateDeviceInstanceResponse build() {
            return new UpdateDeviceInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
