/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUploadRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<UpdateUploadRequest.Builder, UpdateUploadRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUploadRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUploadRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUploadRequest::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<Boolean> EDIT_CONTENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateUploadRequest::editContent)).setter(setter(Builder::editContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("editContent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            CONTENT_TYPE_FIELD, EDIT_CONTENT_FIELD));

    private final String arn;

    private final String name;

    private final String contentType;

    private final Boolean editContent;

    private UpdateUploadRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.contentType = builder.contentType;
        this.editContent = builder.editContent;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the uploaded test spec.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the uploaded test spec.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The upload's test spec file name. The name should not contain the '/' character. The test spec file name must end
     * with the <code>.yaml</code> or <code>.yml</code> file extension.
     * </p>
     * 
     * @return The upload's test spec file name. The name should not contain the '/' character. The test spec file name
     *         must end with the <code>.yaml</code> or <code>.yml</code> file extension.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The upload's content type (for example, "application/x-yaml").
     * </p>
     * 
     * @return The upload's content type (for example, "application/x-yaml").
     */
    public String contentType() {
        return contentType;
    }

    /**
     * <p>
     * Set to true if the YAML file has changed and needs to be updated; otherwise, set to false.
     * </p>
     * 
     * @return Set to true if the YAML file has changed and needs to be updated; otherwise, set to false.
     */
    public Boolean editContent() {
        return editContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(editContent());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUploadRequest)) {
            return false;
        }
        UpdateUploadRequest other = (UpdateUploadRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(contentType(), other.contentType()) && Objects.equals(editContent(), other.editContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateUploadRequest").add("Arn", arn()).add("Name", name()).add("ContentType", contentType())
                .add("EditContent", editContent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "editContent":
            return Optional.ofNullable(clazz.cast(editContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUploadRequest, T> g) {
        return obj -> g.apply((UpdateUploadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUploadRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the uploaded test spec.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the uploaded test spec.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The upload's test spec file name. The name should not contain the '/' character. The test spec file name must
         * end with the <code>.yaml</code> or <code>.yml</code> file extension.
         * </p>
         * 
         * @param name
         *        The upload's test spec file name. The name should not contain the '/' character. The test spec file
         *        name must end with the <code>.yaml</code> or <code>.yml</code> file extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The upload's content type (for example, "application/x-yaml").
         * </p>
         * 
         * @param contentType
         *        The upload's content type (for example, "application/x-yaml").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Set to true if the YAML file has changed and needs to be updated; otherwise, set to false.
         * </p>
         * 
         * @param editContent
         *        Set to true if the YAML file has changed and needs to be updated; otherwise, set to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder editContent(Boolean editContent);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String contentType;

        private Boolean editContent;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUploadRequest model) {
            super(model);
            arn(model.arn);
            name(model.name);
            contentType(model.contentType);
            editContent(model.editContent);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final Boolean getEditContent() {
            return editContent;
        }

        @Override
        public final Builder editContent(Boolean editContent) {
            this.editContent = editContent;
            return this;
        }

        public final void setEditContent(Boolean editContent) {
            this.editContent = editContent;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUploadRequest build() {
            return new UpdateUploadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
