/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of describe device pool compatibility request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDevicePoolCompatibilityResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<GetDevicePoolCompatibilityResponse.Builder, GetDevicePoolCompatibilityResponse> {
    private static final SdkField<List<DevicePoolCompatibilityResult>> COMPATIBLE_DEVICES_FIELD = SdkField
            .<List<DevicePoolCompatibilityResult>> builder(MarshallingType.LIST)
            .getter(getter(GetDevicePoolCompatibilityResponse::compatibleDevices))
            .setter(setter(Builder::compatibleDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibleDevices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DevicePoolCompatibilityResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(DevicePoolCompatibilityResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DevicePoolCompatibilityResult>> INCOMPATIBLE_DEVICES_FIELD = SdkField
            .<List<DevicePoolCompatibilityResult>> builder(MarshallingType.LIST)
            .getter(getter(GetDevicePoolCompatibilityResponse::incompatibleDevices))
            .setter(setter(Builder::incompatibleDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incompatibleDevices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DevicePoolCompatibilityResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(DevicePoolCompatibilityResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPATIBLE_DEVICES_FIELD,
            INCOMPATIBLE_DEVICES_FIELD));

    private final List<DevicePoolCompatibilityResult> compatibleDevices;

    private final List<DevicePoolCompatibilityResult> incompatibleDevices;

    private GetDevicePoolCompatibilityResponse(BuilderImpl builder) {
        super(builder);
        this.compatibleDevices = builder.compatibleDevices;
        this.incompatibleDevices = builder.incompatibleDevices;
    }

    /**
     * Returns true if the CompatibleDevices property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCompatibleDevices() {
        return compatibleDevices != null && !(compatibleDevices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about compatible devices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCompatibleDevices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about compatible devices.
     */
    public List<DevicePoolCompatibilityResult> compatibleDevices() {
        return compatibleDevices;
    }

    /**
     * Returns true if the IncompatibleDevices property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasIncompatibleDevices() {
        return incompatibleDevices != null && !(incompatibleDevices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about incompatible devices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIncompatibleDevices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about incompatible devices.
     */
    public List<DevicePoolCompatibilityResult> incompatibleDevices() {
        return incompatibleDevices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(compatibleDevices());
        hashCode = 31 * hashCode + Objects.hashCode(incompatibleDevices());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePoolCompatibilityResponse)) {
            return false;
        }
        GetDevicePoolCompatibilityResponse other = (GetDevicePoolCompatibilityResponse) obj;
        return Objects.equals(compatibleDevices(), other.compatibleDevices())
                && Objects.equals(incompatibleDevices(), other.incompatibleDevices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDevicePoolCompatibilityResponse").add("CompatibleDevices", compatibleDevices())
                .add("IncompatibleDevices", incompatibleDevices()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "compatibleDevices":
            return Optional.ofNullable(clazz.cast(compatibleDevices()));
        case "incompatibleDevices":
            return Optional.ofNullable(clazz.cast(incompatibleDevices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDevicePoolCompatibilityResponse, T> g) {
        return obj -> g.apply((GetDevicePoolCompatibilityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDevicePoolCompatibilityResponse> {
        /**
         * <p>
         * Information about compatible devices.
         * </p>
         * 
         * @param compatibleDevices
         *        Information about compatible devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleDevices(Collection<DevicePoolCompatibilityResult> compatibleDevices);

        /**
         * <p>
         * Information about compatible devices.
         * </p>
         * 
         * @param compatibleDevices
         *        Information about compatible devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleDevices(DevicePoolCompatibilityResult... compatibleDevices);

        /**
         * <p>
         * Information about compatible devices.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DevicePoolCompatibilityResult>.Builder}
         * avoiding the need to create one manually via {@link List<DevicePoolCompatibilityResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DevicePoolCompatibilityResult>.Builder#build()} is called
         * immediately and its result is passed to {@link #compatibleDevices(List<DevicePoolCompatibilityResult>)}.
         * 
         * @param compatibleDevices
         *        a consumer that will call methods on {@link List<DevicePoolCompatibilityResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compatibleDevices(List<DevicePoolCompatibilityResult>)
         */
        Builder compatibleDevices(Consumer<DevicePoolCompatibilityResult.Builder>... compatibleDevices);

        /**
         * <p>
         * Information about incompatible devices.
         * </p>
         * 
         * @param incompatibleDevices
         *        Information about incompatible devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incompatibleDevices(Collection<DevicePoolCompatibilityResult> incompatibleDevices);

        /**
         * <p>
         * Information about incompatible devices.
         * </p>
         * 
         * @param incompatibleDevices
         *        Information about incompatible devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incompatibleDevices(DevicePoolCompatibilityResult... incompatibleDevices);

        /**
         * <p>
         * Information about incompatible devices.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DevicePoolCompatibilityResult>.Builder}
         * avoiding the need to create one manually via {@link List<DevicePoolCompatibilityResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DevicePoolCompatibilityResult>.Builder#build()} is called
         * immediately and its result is passed to {@link #incompatibleDevices(List<DevicePoolCompatibilityResult>)}.
         * 
         * @param incompatibleDevices
         *        a consumer that will call methods on {@link List<DevicePoolCompatibilityResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incompatibleDevices(List<DevicePoolCompatibilityResult>)
         */
        Builder incompatibleDevices(Consumer<DevicePoolCompatibilityResult.Builder>... incompatibleDevices);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<DevicePoolCompatibilityResult> compatibleDevices = DefaultSdkAutoConstructList.getInstance();

        private List<DevicePoolCompatibilityResult> incompatibleDevices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePoolCompatibilityResponse model) {
            super(model);
            compatibleDevices(model.compatibleDevices);
            incompatibleDevices(model.incompatibleDevices);
        }

        public final Collection<DevicePoolCompatibilityResult.Builder> getCompatibleDevices() {
            return compatibleDevices != null ? compatibleDevices.stream().map(DevicePoolCompatibilityResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder compatibleDevices(Collection<DevicePoolCompatibilityResult> compatibleDevices) {
            this.compatibleDevices = DevicePoolCompatibilityResultsCopier.copy(compatibleDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleDevices(DevicePoolCompatibilityResult... compatibleDevices) {
            compatibleDevices(Arrays.asList(compatibleDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleDevices(Consumer<DevicePoolCompatibilityResult.Builder>... compatibleDevices) {
            compatibleDevices(Stream.of(compatibleDevices)
                    .map(c -> DevicePoolCompatibilityResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCompatibleDevices(Collection<DevicePoolCompatibilityResult.BuilderImpl> compatibleDevices) {
            this.compatibleDevices = DevicePoolCompatibilityResultsCopier.copyFromBuilder(compatibleDevices);
        }

        public final Collection<DevicePoolCompatibilityResult.Builder> getIncompatibleDevices() {
            return incompatibleDevices != null ? incompatibleDevices.stream().map(DevicePoolCompatibilityResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder incompatibleDevices(Collection<DevicePoolCompatibilityResult> incompatibleDevices) {
            this.incompatibleDevices = DevicePoolCompatibilityResultsCopier.copy(incompatibleDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incompatibleDevices(DevicePoolCompatibilityResult... incompatibleDevices) {
            incompatibleDevices(Arrays.asList(incompatibleDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incompatibleDevices(Consumer<DevicePoolCompatibilityResult.Builder>... incompatibleDevices) {
            incompatibleDevices(Stream.of(incompatibleDevices)
                    .map(c -> DevicePoolCompatibilityResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIncompatibleDevices(Collection<DevicePoolCompatibilityResult.BuilderImpl> incompatibleDevices) {
            this.incompatibleDevices = DevicePoolCompatibilityResultsCopier.copyFromBuilder(incompatibleDevices);
        }

        @Override
        public GetDevicePoolCompatibilityResponse build() {
            return new GetDevicePoolCompatibilityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
