/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A number that represents the monetary amount for an offering or transaction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonetaryAmount implements SdkPojo, Serializable, ToCopyableBuilder<MonetaryAmount.Builder, MonetaryAmount> {
    private static final SdkField<Double> AMOUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(MonetaryAmount::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MonetaryAmount::currencyCodeAsString)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD,
            CURRENCY_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double amount;

    private final String currencyCode;

    private MonetaryAmount(BuilderImpl builder) {
        this.amount = builder.amount;
        this.currencyCode = builder.currencyCode;
    }

    /**
     * <p>
     * The numerical amount of an offering or transaction.
     * </p>
     * 
     * @return The numerical amount of an offering or transaction.
     */
    public Double amount() {
        return amount;
    }

    /**
     * <p>
     * The currency code of a monetary amount. For example, <code>USD</code> means U.S. dollars.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency code of a monetary amount. For example, <code>USD</code> means U.S. dollars.
     * @see CurrencyCode
     */
    public CurrencyCode currencyCode() {
        return CurrencyCode.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency code of a monetary amount. For example, <code>USD</code> means U.S. dollars.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency code of a monetary amount. For example, <code>USD</code> means U.S. dollars.
     * @see CurrencyCode
     */
    public String currencyCodeAsString() {
        return currencyCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonetaryAmount)) {
            return false;
        }
        MonetaryAmount other = (MonetaryAmount) obj;
        return Objects.equals(amount(), other.amount()) && Objects.equals(currencyCodeAsString(), other.currencyCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MonetaryAmount").add("Amount", amount()).add("CurrencyCode", currencyCodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amount":
            return Optional.ofNullable(clazz.cast(amount()));
        case "currencyCode":
            return Optional.ofNullable(clazz.cast(currencyCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonetaryAmount, T> g) {
        return obj -> g.apply((MonetaryAmount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonetaryAmount> {
        /**
         * <p>
         * The numerical amount of an offering or transaction.
         * </p>
         * 
         * @param amount
         *        The numerical amount of an offering or transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Double amount);

        /**
         * <p>
         * The currency code of a monetary amount. For example, <code>USD</code> means U.S. dollars.
         * </p>
         * 
         * @param currencyCode
         *        The currency code of a monetary amount. For example, <code>USD</code> means U.S. dollars.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency code of a monetary amount. For example, <code>USD</code> means U.S. dollars.
         * </p>
         * 
         * @param currencyCode
         *        The currency code of a monetary amount. For example, <code>USD</code> means U.S. dollars.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currencyCode(CurrencyCode currencyCode);
    }

    static final class BuilderImpl implements Builder {
        private Double amount;

        private String currencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(MonetaryAmount model) {
            amount(model.amount);
            currencyCode(model.currencyCode);
        }

        public final Double getAmount() {
            return amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        public final String getCurrencyCodeAsString() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public MonetaryAmount build() {
            return new MonetaryAmount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
