/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNetworkProfileRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<CreateNetworkProfileRequest.Builder, CreateNetworkProfileRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateNetworkProfileRequest::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateNetworkProfileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateNetworkProfileRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateNetworkProfileRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Long> UPLINK_BANDWIDTH_BITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateNetworkProfileRequest::uplinkBandwidthBits)).setter(setter(Builder::uplinkBandwidthBits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uplinkBandwidthBits").build())
            .build();

    private static final SdkField<Long> DOWNLINK_BANDWIDTH_BITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateNetworkProfileRequest::downlinkBandwidthBits)).setter(setter(Builder::downlinkBandwidthBits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downlinkBandwidthBits").build())
            .build();

    private static final SdkField<Long> UPLINK_DELAY_MS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateNetworkProfileRequest::uplinkDelayMs)).setter(setter(Builder::uplinkDelayMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uplinkDelayMs").build()).build();

    private static final SdkField<Long> DOWNLINK_DELAY_MS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateNetworkProfileRequest::downlinkDelayMs)).setter(setter(Builder::downlinkDelayMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downlinkDelayMs").build()).build();

    private static final SdkField<Long> UPLINK_JITTER_MS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateNetworkProfileRequest::uplinkJitterMs)).setter(setter(Builder::uplinkJitterMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uplinkJitterMs").build()).build();

    private static final SdkField<Long> DOWNLINK_JITTER_MS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateNetworkProfileRequest::downlinkJitterMs)).setter(setter(Builder::downlinkJitterMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downlinkJitterMs").build()).build();

    private static final SdkField<Integer> UPLINK_LOSS_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateNetworkProfileRequest::uplinkLossPercent)).setter(setter(Builder::uplinkLossPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uplinkLossPercent").build()).build();

    private static final SdkField<Integer> DOWNLINK_LOSS_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateNetworkProfileRequest::downlinkLossPercent)).setter(setter(Builder::downlinkLossPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downlinkLossPercent").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, TYPE_FIELD, UPLINK_BANDWIDTH_BITS_FIELD, DOWNLINK_BANDWIDTH_BITS_FIELD, UPLINK_DELAY_MS_FIELD,
            DOWNLINK_DELAY_MS_FIELD, UPLINK_JITTER_MS_FIELD, DOWNLINK_JITTER_MS_FIELD, UPLINK_LOSS_PERCENT_FIELD,
            DOWNLINK_LOSS_PERCENT_FIELD));

    private final String projectArn;

    private final String name;

    private final String description;

    private final String type;

    private final Long uplinkBandwidthBits;

    private final Long downlinkBandwidthBits;

    private final Long uplinkDelayMs;

    private final Long downlinkDelayMs;

    private final Long uplinkJitterMs;

    private final Long downlinkJitterMs;

    private final Integer uplinkLossPercent;

    private final Integer downlinkLossPercent;

    private CreateNetworkProfileRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.uplinkBandwidthBits = builder.uplinkBandwidthBits;
        this.downlinkBandwidthBits = builder.downlinkBandwidthBits;
        this.uplinkDelayMs = builder.uplinkDelayMs;
        this.downlinkDelayMs = builder.downlinkDelayMs;
        this.uplinkJitterMs = builder.uplinkJitterMs;
        this.downlinkJitterMs = builder.downlinkJitterMs;
        this.uplinkLossPercent = builder.uplinkLossPercent;
        this.downlinkLossPercent = builder.downlinkLossPercent;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project for which you want to create a network profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project for which you want to create a network profile.
     */
    public String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * The name for the new network profile.
     * </p>
     * 
     * @return The name for the new network profile.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the network profile.
     * </p>
     * 
     * @return The description of the network profile.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The type of network profile to create. Valid values are listed here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NetworkProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of network profile to create. Valid values are listed here.
     * @see NetworkProfileType
     */
    public NetworkProfileType type() {
        return NetworkProfileType.fromValue(type);
    }

    /**
     * <p>
     * The type of network profile to create. Valid values are listed here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NetworkProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of network profile to create. Valid values are listed here.
     * @see NetworkProfileType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The data throughput rate in bits per second, as an integer from 0 to 104857600.
     * </p>
     * 
     * @return The data throughput rate in bits per second, as an integer from 0 to 104857600.
     */
    public Long uplinkBandwidthBits() {
        return uplinkBandwidthBits;
    }

    /**
     * <p>
     * The data throughput rate in bits per second, as an integer from 0 to 104857600.
     * </p>
     * 
     * @return The data throughput rate in bits per second, as an integer from 0 to 104857600.
     */
    public Long downlinkBandwidthBits() {
        return downlinkBandwidthBits;
    }

    /**
     * <p>
     * Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
     * </p>
     * 
     * @return Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
     */
    public Long uplinkDelayMs() {
        return uplinkDelayMs;
    }

    /**
     * <p>
     * Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
     * </p>
     * 
     * @return Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
     */
    public Long downlinkDelayMs() {
        return downlinkDelayMs;
    }

    /**
     * <p>
     * Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
     * </p>
     * 
     * @return Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
     */
    public Long uplinkJitterMs() {
        return uplinkJitterMs;
    }

    /**
     * <p>
     * Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
     * </p>
     * 
     * @return Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
     */
    public Long downlinkJitterMs() {
        return downlinkJitterMs;
    }

    /**
     * <p>
     * Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
     * </p>
     * 
     * @return Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
     */
    public Integer uplinkLossPercent() {
        return uplinkLossPercent;
    }

    /**
     * <p>
     * Proportion of received packets that fail to arrive from 0 to 100 percent.
     * </p>
     * 
     * @return Proportion of received packets that fail to arrive from 0 to 100 percent.
     */
    public Integer downlinkLossPercent() {
        return downlinkLossPercent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uplinkBandwidthBits());
        hashCode = 31 * hashCode + Objects.hashCode(downlinkBandwidthBits());
        hashCode = 31 * hashCode + Objects.hashCode(uplinkDelayMs());
        hashCode = 31 * hashCode + Objects.hashCode(downlinkDelayMs());
        hashCode = 31 * hashCode + Objects.hashCode(uplinkJitterMs());
        hashCode = 31 * hashCode + Objects.hashCode(downlinkJitterMs());
        hashCode = 31 * hashCode + Objects.hashCode(uplinkLossPercent());
        hashCode = 31 * hashCode + Objects.hashCode(downlinkLossPercent());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkProfileRequest)) {
            return false;
        }
        CreateNetworkProfileRequest other = (CreateNetworkProfileRequest) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(uplinkBandwidthBits(), other.uplinkBandwidthBits())
                && Objects.equals(downlinkBandwidthBits(), other.downlinkBandwidthBits())
                && Objects.equals(uplinkDelayMs(), other.uplinkDelayMs())
                && Objects.equals(downlinkDelayMs(), other.downlinkDelayMs())
                && Objects.equals(uplinkJitterMs(), other.uplinkJitterMs())
                && Objects.equals(downlinkJitterMs(), other.downlinkJitterMs())
                && Objects.equals(uplinkLossPercent(), other.uplinkLossPercent())
                && Objects.equals(downlinkLossPercent(), other.downlinkLossPercent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateNetworkProfileRequest").add("ProjectArn", projectArn()).add("Name", name())
                .add("Description", description()).add("Type", typeAsString()).add("UplinkBandwidthBits", uplinkBandwidthBits())
                .add("DownlinkBandwidthBits", downlinkBandwidthBits()).add("UplinkDelayMs", uplinkDelayMs())
                .add("DownlinkDelayMs", downlinkDelayMs()).add("UplinkJitterMs", uplinkJitterMs())
                .add("DownlinkJitterMs", downlinkJitterMs()).add("UplinkLossPercent", uplinkLossPercent())
                .add("DownlinkLossPercent", downlinkLossPercent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "uplinkBandwidthBits":
            return Optional.ofNullable(clazz.cast(uplinkBandwidthBits()));
        case "downlinkBandwidthBits":
            return Optional.ofNullable(clazz.cast(downlinkBandwidthBits()));
        case "uplinkDelayMs":
            return Optional.ofNullable(clazz.cast(uplinkDelayMs()));
        case "downlinkDelayMs":
            return Optional.ofNullable(clazz.cast(downlinkDelayMs()));
        case "uplinkJitterMs":
            return Optional.ofNullable(clazz.cast(uplinkJitterMs()));
        case "downlinkJitterMs":
            return Optional.ofNullable(clazz.cast(downlinkJitterMs()));
        case "uplinkLossPercent":
            return Optional.ofNullable(clazz.cast(uplinkLossPercent()));
        case "downlinkLossPercent":
            return Optional.ofNullable(clazz.cast(downlinkLossPercent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkProfileRequest, T> g) {
        return obj -> g.apply((CreateNetworkProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateNetworkProfileRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project for which you want to create a network profile.
         * </p>
         * 
         * @param projectArn
         *        The Amazon Resource Name (ARN) of the project for which you want to create a network profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * The name for the new network profile.
         * </p>
         * 
         * @param name
         *        The name for the new network profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the network profile.
         * </p>
         * 
         * @param description
         *        The description of the network profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of network profile to create. Valid values are listed here.
         * </p>
         * 
         * @param type
         *        The type of network profile to create. Valid values are listed here.
         * @see NetworkProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProfileType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of network profile to create. Valid values are listed here.
         * </p>
         * 
         * @param type
         *        The type of network profile to create. Valid values are listed here.
         * @see NetworkProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProfileType
         */
        Builder type(NetworkProfileType type);

        /**
         * <p>
         * The data throughput rate in bits per second, as an integer from 0 to 104857600.
         * </p>
         * 
         * @param uplinkBandwidthBits
         *        The data throughput rate in bits per second, as an integer from 0 to 104857600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uplinkBandwidthBits(Long uplinkBandwidthBits);

        /**
         * <p>
         * The data throughput rate in bits per second, as an integer from 0 to 104857600.
         * </p>
         * 
         * @param downlinkBandwidthBits
         *        The data throughput rate in bits per second, as an integer from 0 to 104857600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkBandwidthBits(Long downlinkBandwidthBits);

        /**
         * <p>
         * Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
         * </p>
         * 
         * @param uplinkDelayMs
         *        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uplinkDelayMs(Long uplinkDelayMs);

        /**
         * <p>
         * Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
         * </p>
         * 
         * @param downlinkDelayMs
         *        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkDelayMs(Long downlinkDelayMs);

        /**
         * <p>
         * Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
         * </p>
         * 
         * @param uplinkJitterMs
         *        Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uplinkJitterMs(Long uplinkJitterMs);

        /**
         * <p>
         * Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
         * </p>
         * 
         * @param downlinkJitterMs
         *        Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkJitterMs(Long downlinkJitterMs);

        /**
         * <p>
         * Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
         * </p>
         * 
         * @param uplinkLossPercent
         *        Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uplinkLossPercent(Integer uplinkLossPercent);

        /**
         * <p>
         * Proportion of received packets that fail to arrive from 0 to 100 percent.
         * </p>
         * 
         * @param downlinkLossPercent
         *        Proportion of received packets that fail to arrive from 0 to 100 percent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkLossPercent(Integer downlinkLossPercent);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String projectArn;

        private String name;

        private String description;

        private String type;

        private Long uplinkBandwidthBits;

        private Long downlinkBandwidthBits;

        private Long uplinkDelayMs;

        private Long downlinkDelayMs;

        private Long uplinkJitterMs;

        private Long downlinkJitterMs;

        private Integer uplinkLossPercent;

        private Integer downlinkLossPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkProfileRequest model) {
            super(model);
            projectArn(model.projectArn);
            name(model.name);
            description(model.description);
            type(model.type);
            uplinkBandwidthBits(model.uplinkBandwidthBits);
            downlinkBandwidthBits(model.downlinkBandwidthBits);
            uplinkDelayMs(model.uplinkDelayMs);
            downlinkDelayMs(model.downlinkDelayMs);
            uplinkJitterMs(model.uplinkJitterMs);
            downlinkJitterMs(model.downlinkJitterMs);
            uplinkLossPercent(model.uplinkLossPercent);
            downlinkLossPercent(model.downlinkLossPercent);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NetworkProfileType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Long getUplinkBandwidthBits() {
            return uplinkBandwidthBits;
        }

        @Override
        public final Builder uplinkBandwidthBits(Long uplinkBandwidthBits) {
            this.uplinkBandwidthBits = uplinkBandwidthBits;
            return this;
        }

        public final void setUplinkBandwidthBits(Long uplinkBandwidthBits) {
            this.uplinkBandwidthBits = uplinkBandwidthBits;
        }

        public final Long getDownlinkBandwidthBits() {
            return downlinkBandwidthBits;
        }

        @Override
        public final Builder downlinkBandwidthBits(Long downlinkBandwidthBits) {
            this.downlinkBandwidthBits = downlinkBandwidthBits;
            return this;
        }

        public final void setDownlinkBandwidthBits(Long downlinkBandwidthBits) {
            this.downlinkBandwidthBits = downlinkBandwidthBits;
        }

        public final Long getUplinkDelayMs() {
            return uplinkDelayMs;
        }

        @Override
        public final Builder uplinkDelayMs(Long uplinkDelayMs) {
            this.uplinkDelayMs = uplinkDelayMs;
            return this;
        }

        public final void setUplinkDelayMs(Long uplinkDelayMs) {
            this.uplinkDelayMs = uplinkDelayMs;
        }

        public final Long getDownlinkDelayMs() {
            return downlinkDelayMs;
        }

        @Override
        public final Builder downlinkDelayMs(Long downlinkDelayMs) {
            this.downlinkDelayMs = downlinkDelayMs;
            return this;
        }

        public final void setDownlinkDelayMs(Long downlinkDelayMs) {
            this.downlinkDelayMs = downlinkDelayMs;
        }

        public final Long getUplinkJitterMs() {
            return uplinkJitterMs;
        }

        @Override
        public final Builder uplinkJitterMs(Long uplinkJitterMs) {
            this.uplinkJitterMs = uplinkJitterMs;
            return this;
        }

        public final void setUplinkJitterMs(Long uplinkJitterMs) {
            this.uplinkJitterMs = uplinkJitterMs;
        }

        public final Long getDownlinkJitterMs() {
            return downlinkJitterMs;
        }

        @Override
        public final Builder downlinkJitterMs(Long downlinkJitterMs) {
            this.downlinkJitterMs = downlinkJitterMs;
            return this;
        }

        public final void setDownlinkJitterMs(Long downlinkJitterMs) {
            this.downlinkJitterMs = downlinkJitterMs;
        }

        public final Integer getUplinkLossPercent() {
            return uplinkLossPercent;
        }

        @Override
        public final Builder uplinkLossPercent(Integer uplinkLossPercent) {
            this.uplinkLossPercent = uplinkLossPercent;
            return this;
        }

        public final void setUplinkLossPercent(Integer uplinkLossPercent) {
            this.uplinkLossPercent = uplinkLossPercent;
        }

        public final Integer getDownlinkLossPercent() {
            return downlinkLossPercent;
        }

        @Override
        public final Builder downlinkLossPercent(Integer downlinkLossPercent) {
            this.downlinkLossPercent = downlinkLossPercent;
            return this;
        }

        public final void setDownlinkLossPercent(Integer downlinkLossPercent) {
            this.downlinkLossPercent = downlinkLossPercent;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkProfileRequest build() {
            return new CreateNetworkProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
