/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTestGridUrlResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<CreateTestGridUrlResponse.Builder, CreateTestGridUrlResponse> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTestGridUrlResponse::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<Instant> EXPIRES_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateTestGridUrlResponse::expires)).setter(setter(Builder::expires))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expires").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, EXPIRES_FIELD));

    private final String url;

    private final Instant expires;

    private CreateTestGridUrlResponse(BuilderImpl builder) {
        super(builder);
        this.url = builder.url;
        this.expires = builder.expires;
    }

    /**
     * <p>
     * A signed URL, expiring in <a>CreateTestGridUrlRequest$expiresInSeconds</a> seconds, to be passed to a
     * <code>RemoteWebDriver</code>.
     * </p>
     * 
     * @return A signed URL, expiring in <a>CreateTestGridUrlRequest$expiresInSeconds</a> seconds, to be passed to a
     *         <code>RemoteWebDriver</code>.
     */
    public String url() {
        return url;
    }

    /**
     * <p>
     * The number of seconds the URL from <a>CreateTestGridUrlResult$url</a> stays active.
     * </p>
     * 
     * @return The number of seconds the URL from <a>CreateTestGridUrlResult$url</a> stays active.
     */
    public Instant expires() {
        return expires;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(expires());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTestGridUrlResponse)) {
            return false;
        }
        CreateTestGridUrlResponse other = (CreateTestGridUrlResponse) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(expires(), other.expires());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTestGridUrlResponse").add("Url", url()).add("Expires", expires()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "expires":
            return Optional.ofNullable(clazz.cast(expires()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTestGridUrlResponse, T> g) {
        return obj -> g.apply((CreateTestGridUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTestGridUrlResponse> {
        /**
         * <p>
         * A signed URL, expiring in <a>CreateTestGridUrlRequest$expiresInSeconds</a> seconds, to be passed to a
         * <code>RemoteWebDriver</code>.
         * </p>
         * 
         * @param url
         *        A signed URL, expiring in <a>CreateTestGridUrlRequest$expiresInSeconds</a> seconds, to be passed to a
         *        <code>RemoteWebDriver</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The number of seconds the URL from <a>CreateTestGridUrlResult$url</a> stays active.
         * </p>
         * 
         * @param expires
         *        The number of seconds the URL from <a>CreateTestGridUrlResult$url</a> stays active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expires(Instant expires);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private String url;

        private Instant expires;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTestGridUrlResponse model) {
            super(model);
            url(model.url);
            expires(model.expires);
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final Instant getExpires() {
            return expires;
        }

        @Override
        public final Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        public final void setExpires(Instant expires) {
            this.expires = expires;
        }

        @Override
        public CreateTestGridUrlResponse build() {
            return new CreateTestGridUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
