/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the run results requested by the device selection configuration and how many devices were returned. For an
 * example of the JSON response syntax, see <a>ScheduleRun</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceSelectionResult implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceSelectionResult.Builder, DeviceSelectionResult> {
    private static final SdkField<List<DeviceFilter>> FILTERS_FIELD = SdkField
            .<List<DeviceFilter>> builder(MarshallingType.LIST)
            .getter(getter(DeviceSelectionResult::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MATCHED_DEVICES_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DeviceSelectionResult::matchedDevicesCount)).setter(setter(Builder::matchedDevicesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchedDevicesCount").build())
            .build();

    private static final SdkField<Integer> MAX_DEVICES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DeviceSelectionResult::maxDevices)).setter(setter(Builder::maxDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDevices").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MATCHED_DEVICES_COUNT_FIELD, MAX_DEVICES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DeviceFilter> filters;

    private final Integer matchedDevicesCount;

    private final Integer maxDevices;

    private DeviceSelectionResult(BuilderImpl builder) {
        this.filters = builder.filters;
        this.matchedDevicesCount = builder.matchedDevicesCount;
        this.maxDevices = builder.maxDevices;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters in a device selection result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filters in a device selection result.
     */
    public List<DeviceFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The number of devices that matched the device filter selection criteria.
     * </p>
     * 
     * @return The number of devices that matched the device filter selection criteria.
     */
    public Integer matchedDevicesCount() {
        return matchedDevicesCount;
    }

    /**
     * <p>
     * The maximum number of devices to be selected by a device filter and included in a test run.
     * </p>
     * 
     * @return The maximum number of devices to be selected by a device filter and included in a test run.
     */
    public Integer maxDevices() {
        return maxDevices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(matchedDevicesCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxDevices());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSelectionResult)) {
            return false;
        }
        DeviceSelectionResult other = (DeviceSelectionResult) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(matchedDevicesCount(), other.matchedDevicesCount())
                && Objects.equals(maxDevices(), other.maxDevices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeviceSelectionResult").add("Filters", filters())
                .add("MatchedDevicesCount", matchedDevicesCount()).add("MaxDevices", maxDevices()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "matchedDevicesCount":
            return Optional.ofNullable(clazz.cast(matchedDevicesCount()));
        case "maxDevices":
            return Optional.ofNullable(clazz.cast(maxDevices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceSelectionResult, T> g) {
        return obj -> g.apply((DeviceSelectionResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceSelectionResult> {
        /**
         * <p>
         * The filters in a device selection result.
         * </p>
         * 
         * @param filters
         *        The filters in a device selection result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<DeviceFilter> filters);

        /**
         * <p>
         * The filters in a device selection result.
         * </p>
         * 
         * @param filters
         *        The filters in a device selection result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(DeviceFilter... filters);

        /**
         * <p>
         * The filters in a device selection result.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeviceFilter>.Builder} avoiding the need to
         * create one manually via {@link List<DeviceFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<DeviceFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<DeviceFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<DeviceFilter>)
         */
        Builder filters(Consumer<DeviceFilter.Builder>... filters);

        /**
         * <p>
         * The number of devices that matched the device filter selection criteria.
         * </p>
         * 
         * @param matchedDevicesCount
         *        The number of devices that matched the device filter selection criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedDevicesCount(Integer matchedDevicesCount);

        /**
         * <p>
         * The maximum number of devices to be selected by a device filter and included in a test run.
         * </p>
         * 
         * @param maxDevices
         *        The maximum number of devices to be selected by a device filter and included in a test run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDevices(Integer maxDevices);
    }

    static final class BuilderImpl implements Builder {
        private List<DeviceFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer matchedDevicesCount;

        private Integer maxDevices;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceSelectionResult model) {
            filters(model.filters);
            matchedDevicesCount(model.matchedDevicesCount);
            maxDevices(model.maxDevices);
        }

        public final Collection<DeviceFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(DeviceFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<DeviceFilter> filters) {
            this.filters = DeviceFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DeviceFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<DeviceFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> DeviceFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<DeviceFilter.BuilderImpl> filters) {
            this.filters = DeviceFiltersCopier.copyFromBuilder(filters);
        }

        public final Integer getMatchedDevicesCount() {
            return matchedDevicesCount;
        }

        @Override
        public final Builder matchedDevicesCount(Integer matchedDevicesCount) {
            this.matchedDevicesCount = matchedDevicesCount;
            return this;
        }

        public final void setMatchedDevicesCount(Integer matchedDevicesCount) {
            this.matchedDevicesCount = matchedDevicesCount;
        }

        public final Integer getMaxDevices() {
            return maxDevices;
        }

        @Override
        public final Builder maxDevices(Integer maxDevices) {
            this.maxDevices = maxDevices;
            return this;
        }

        public final void setMaxDevices(Integer maxDevices) {
            this.maxDevices = maxDevices;
        }

        @Override
        public DeviceSelectionResult build() {
            return new DeviceSelectionResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
