/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestGridProjectsRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<ListTestGridProjectsRequest.Builder, ListTestGridProjectsRequest> {
    private static final SdkField<Integer> MAX_RESULT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListTestGridProjectsRequest::maxResult)).setter(setter(Builder::maxResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResult").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTestGridProjectsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULT_FIELD,
            NEXT_TOKEN_FIELD));

    private final Integer maxResult;

    private final String nextToken;

    private ListTestGridProjectsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResult = builder.maxResult;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Return no more than this number of results.
     * </p>
     * 
     * @return Return no more than this number of results.
     */
    public Integer maxResult() {
        return maxResult;
    }

    /**
     * <p>
     * From a response, used to continue a paginated listing.
     * </p>
     * 
     * @return From a response, used to continue a paginated listing.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResult());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestGridProjectsRequest)) {
            return false;
        }
        ListTestGridProjectsRequest other = (ListTestGridProjectsRequest) obj;
        return Objects.equals(maxResult(), other.maxResult()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTestGridProjectsRequest").add("MaxResult", maxResult()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResult":
            return Optional.ofNullable(clazz.cast(maxResult()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestGridProjectsRequest, T> g) {
        return obj -> g.apply((ListTestGridProjectsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTestGridProjectsRequest> {
        /**
         * <p>
         * Return no more than this number of results.
         * </p>
         * 
         * @param maxResult
         *        Return no more than this number of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResult(Integer maxResult);

        /**
         * <p>
         * From a response, used to continue a paginated listing.
         * </p>
         * 
         * @param nextToken
         *        From a response, used to continue a paginated listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private Integer maxResult;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestGridProjectsRequest model) {
            super(model);
            maxResult(model.maxResult);
            nextToken(model.nextToken);
        }

        public final Integer getMaxResult() {
            return maxResult;
        }

        @Override
        public final Builder maxResult(Integer maxResult) {
            this.maxResult = maxResult;
            return this;
        }

        public final void setMaxResult(Integer maxResult) {
            this.maxResult = maxResult;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTestGridProjectsRequest build() {
            return new ListTestGridProjectsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
