/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the device instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceInstance implements SdkPojo, Serializable, ToCopyableBuilder<DeviceInstance.Builder, DeviceInstance> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeviceInstance::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeviceInstance::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()).build();

    private static final SdkField<List<String>> LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DeviceInstance::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeviceInstance::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> UDID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeviceInstance::udid)).setter(setter(Builder::udid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("udid").build()).build();

    private static final SdkField<InstanceProfile> INSTANCE_PROFILE_FIELD = SdkField
            .<InstanceProfile> builder(MarshallingType.SDK_POJO).getter(getter(DeviceInstance::instanceProfile))
            .setter(setter(Builder::instanceProfile)).constructor(InstanceProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceProfile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DEVICE_ARN_FIELD,
            LABELS_FIELD, STATUS_FIELD, UDID_FIELD, INSTANCE_PROFILE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String deviceArn;

    private final List<String> labels;

    private final String status;

    private final String udid;

    private final InstanceProfile instanceProfile;

    private DeviceInstance(BuilderImpl builder) {
        this.arn = builder.arn;
        this.deviceArn = builder.deviceArn;
        this.labels = builder.labels;
        this.status = builder.status;
        this.udid = builder.udid;
        this.instanceProfile = builder.instanceProfile;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the device instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the device instance.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN of the device.
     * </p>
     * 
     * @return The ARN of the device.
     */
    public String deviceArn() {
        return deviceArn;
    }

    /**
     * Returns true if the Labels property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings that describe the device instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLabels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of strings that describe the device instance.
     */
    public List<String> labels() {
        return labels;
    }

    /**
     * <p>
     * The status of the device instance. Valid values are listed here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the device instance. Valid values are listed here.
     * @see InstanceStatus
     */
    public InstanceStatus status() {
        return InstanceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the device instance. Valid values are listed here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the device instance. Valid values are listed here.
     * @see InstanceStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Unique device identifier for the device instance.
     * </p>
     * 
     * @return Unique device identifier for the device instance.
     */
    public String udid() {
        return udid;
    }

    /**
     * <p>
     * A object that contains information about the instance profile.
     * </p>
     * 
     * @return A object that contains information about the instance profile.
     */
    public InstanceProfile instanceProfile() {
        return instanceProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(labels());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(udid());
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfile());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceInstance)) {
            return false;
        }
        DeviceInstance other = (DeviceInstance) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(deviceArn(), other.deviceArn())
                && Objects.equals(labels(), other.labels()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(udid(), other.udid()) && Objects.equals(instanceProfile(), other.instanceProfile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeviceInstance").add("Arn", arn()).add("DeviceArn", deviceArn()).add("Labels", labels())
                .add("Status", statusAsString()).add("Udid", udid()).add("InstanceProfile", instanceProfile()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "deviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "udid":
            return Optional.ofNullable(clazz.cast(udid()));
        case "instanceProfile":
            return Optional.ofNullable(clazz.cast(instanceProfile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceInstance, T> g) {
        return obj -> g.apply((DeviceInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceInstance> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the device instance.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the device instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN of the device.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * An array of strings that describe the device instance.
         * </p>
         * 
         * @param labels
         *        An array of strings that describe the device instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<String> labels);

        /**
         * <p>
         * An array of strings that describe the device instance.
         * </p>
         * 
         * @param labels
         *        An array of strings that describe the device instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(String... labels);

        /**
         * <p>
         * The status of the device instance. Valid values are listed here.
         * </p>
         * 
         * @param status
         *        The status of the device instance. Valid values are listed here.
         * @see InstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the device instance. Valid values are listed here.
         * </p>
         * 
         * @param status
         *        The status of the device instance. Valid values are listed here.
         * @see InstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStatus
         */
        Builder status(InstanceStatus status);

        /**
         * <p>
         * Unique device identifier for the device instance.
         * </p>
         * 
         * @param udid
         *        Unique device identifier for the device instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder udid(String udid);

        /**
         * <p>
         * A object that contains information about the instance profile.
         * </p>
         * 
         * @param instanceProfile
         *        A object that contains information about the instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfile(InstanceProfile instanceProfile);

        /**
         * <p>
         * A object that contains information about the instance profile.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceProfile.Builder} avoiding the need to
         * create one manually via {@link InstanceProfile#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceProfile(InstanceProfile)}.
         * 
         * @param instanceProfile
         *        a consumer that will call methods on {@link InstanceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceProfile(InstanceProfile)
         */
        default Builder instanceProfile(Consumer<InstanceProfile.Builder> instanceProfile) {
            return instanceProfile(InstanceProfile.builder().applyMutation(instanceProfile).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String deviceArn;

        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String udid;

        private InstanceProfile instanceProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceInstance model) {
            arn(model.arn);
            deviceArn(model.deviceArn);
            labels(model.labels);
            status(model.status);
            udid(model.udid);
            instanceProfile(model.instanceProfile);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final Collection<String> getLabels() {
            return labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = InstanceLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = InstanceLabelsCopier.copy(labels);
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getUdid() {
            return udid;
        }

        @Override
        public final Builder udid(String udid) {
            this.udid = udid;
            return this;
        }

        public final void setUdid(String udid) {
            this.udid = udid;
        }

        public final InstanceProfile.Builder getInstanceProfile() {
            return instanceProfile != null ? instanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder instanceProfile(InstanceProfile instanceProfile) {
            this.instanceProfile = instanceProfile;
            return this;
        }

        public final void setInstanceProfile(InstanceProfile.BuilderImpl instanceProfile) {
            this.instanceProfile = instanceProfile != null ? instanceProfile.build() : null;
        }

        @Override
        public DeviceInstance build() {
            return new DeviceInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
