/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a renewal offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RenewOfferingResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<RenewOfferingResponse.Builder, RenewOfferingResponse> {
    private static final SdkField<OfferingTransaction> OFFERING_TRANSACTION_FIELD = SdkField
            .<OfferingTransaction> builder(MarshallingType.SDK_POJO).getter(getter(RenewOfferingResponse::offeringTransaction))
            .setter(setter(Builder::offeringTransaction)).constructor(OfferingTransaction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringTransaction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_TRANSACTION_FIELD));

    private final OfferingTransaction offeringTransaction;

    private RenewOfferingResponse(BuilderImpl builder) {
        super(builder);
        this.offeringTransaction = builder.offeringTransaction;
    }

    /**
     * <p>
     * Represents the status of the offering transaction for the renewal.
     * </p>
     * 
     * @return Represents the status of the offering transaction for the renewal.
     */
    public OfferingTransaction offeringTransaction() {
        return offeringTransaction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(offeringTransaction());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewOfferingResponse)) {
            return false;
        }
        RenewOfferingResponse other = (RenewOfferingResponse) obj;
        return Objects.equals(offeringTransaction(), other.offeringTransaction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RenewOfferingResponse").add("OfferingTransaction", offeringTransaction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringTransaction":
            return Optional.ofNullable(clazz.cast(offeringTransaction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RenewOfferingResponse, T> g) {
        return obj -> g.apply((RenewOfferingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, RenewOfferingResponse> {
        /**
         * <p>
         * Represents the status of the offering transaction for the renewal.
         * </p>
         * 
         * @param offeringTransaction
         *        Represents the status of the offering transaction for the renewal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringTransaction(OfferingTransaction offeringTransaction);

        /**
         * <p>
         * Represents the status of the offering transaction for the renewal.
         * </p>
         * This is a convenience that creates an instance of the {@link OfferingTransaction.Builder} avoiding the need
         * to create one manually via {@link OfferingTransaction#builder()}.
         *
         * When the {@link Consumer} completes, {@link OfferingTransaction.Builder#build()} is called immediately and
         * its result is passed to {@link #offeringTransaction(OfferingTransaction)}.
         * 
         * @param offeringTransaction
         *        a consumer that will call methods on {@link OfferingTransaction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offeringTransaction(OfferingTransaction)
         */
        default Builder offeringTransaction(Consumer<OfferingTransaction.Builder> offeringTransaction) {
            return offeringTransaction(OfferingTransaction.builder().applyMutation(offeringTransaction).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private OfferingTransaction offeringTransaction;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewOfferingResponse model) {
            super(model);
            offeringTransaction(model.offeringTransaction);
        }

        public final OfferingTransaction.Builder getOfferingTransaction() {
            return offeringTransaction != null ? offeringTransaction.toBuilder() : null;
        }

        @Override
        public final Builder offeringTransaction(OfferingTransaction offeringTransaction) {
            this.offeringTransaction = offeringTransaction;
            return this;
        }

        public final void setOfferingTransaction(OfferingTransaction.BuilderImpl offeringTransaction) {
            this.offeringTransaction = offeringTransaction != null ? offeringTransaction.build() : null;
        }

        @Override
        public RenewOfferingResponse build() {
            return new RenewOfferingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
