/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about free trial device minutes for an AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrialMinutes implements SdkPojo, Serializable, ToCopyableBuilder<TrialMinutes.Builder, TrialMinutes> {
    private static final SdkField<Double> TOTAL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(TrialMinutes::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final SdkField<Double> REMAINING_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(TrialMinutes::remaining)).setter(setter(Builder::remaining))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remaining").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FIELD, REMAINING_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double total;

    private final Double remaining;

    private TrialMinutes(BuilderImpl builder) {
        this.total = builder.total;
        this.remaining = builder.remaining;
    }

    /**
     * <p>
     * The total number of free trial minutes that the account started with.
     * </p>
     * 
     * @return The total number of free trial minutes that the account started with.
     */
    public Double total() {
        return total;
    }

    /**
     * <p>
     * The number of free trial minutes remaining in the account.
     * </p>
     * 
     * @return The number of free trial minutes remaining in the account.
     */
    public Double remaining() {
        return remaining;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(remaining());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialMinutes)) {
            return false;
        }
        TrialMinutes other = (TrialMinutes) obj;
        return Objects.equals(total(), other.total()) && Objects.equals(remaining(), other.remaining());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TrialMinutes").add("Total", total()).add("Remaining", remaining()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "total":
            return Optional.ofNullable(clazz.cast(total()));
        case "remaining":
            return Optional.ofNullable(clazz.cast(remaining()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialMinutes, T> g) {
        return obj -> g.apply((TrialMinutes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrialMinutes> {
        /**
         * <p>
         * The total number of free trial minutes that the account started with.
         * </p>
         * 
         * @param total
         *        The total number of free trial minutes that the account started with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Double total);

        /**
         * <p>
         * The number of free trial minutes remaining in the account.
         * </p>
         * 
         * @param remaining
         *        The number of free trial minutes remaining in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remaining(Double remaining);
    }

    static final class BuilderImpl implements Builder {
        private Double total;

        private Double remaining;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialMinutes model) {
            total(model.total);
            remaining(model.remaining);
        }

        public final Double getTotal() {
            return total;
        }

        @Override
        public final Builder total(Double total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Double total) {
            this.total = total;
        }

        public final Double getRemaining() {
            return remaining;
        }

        @Override
        public final Builder remaining(Double remaining) {
            this.remaining = remaining;
            return this;
        }

        public final void setRemaining(Double remaining) {
            this.remaining = remaining;
        }

        @Override
        public TrialMinutes build() {
            return new TrialMinutes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
