/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates and submits a request to start a remote access session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRemoteAccessSessionRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<CreateRemoteAccessSessionRequest.Builder, CreateRemoteAccessSessionRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRemoteAccessSessionRequest::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()).build();

    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRemoteAccessSessionRequest::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRemoteAccessSessionRequest::instanceArn)).setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRemoteAccessSessionRequest::sshPublicKey)).setter(setter(Builder::sshPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sshPublicKey").build()).build();

    private static final SdkField<Boolean> REMOTE_DEBUG_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateRemoteAccessSessionRequest::remoteDebugEnabled)).setter(setter(Builder::remoteDebugEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteDebugEnabled").build())
            .build();

    private static final SdkField<Boolean> REMOTE_RECORD_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateRemoteAccessSessionRequest::remoteRecordEnabled)).setter(setter(Builder::remoteRecordEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteRecordEnabled").build())
            .build();

    private static final SdkField<String> REMOTE_RECORD_APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRemoteAccessSessionRequest::remoteRecordAppArn)).setter(setter(Builder::remoteRecordAppArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteRecordAppArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRemoteAccessSessionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRemoteAccessSessionRequest::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();

    private static final SdkField<CreateRemoteAccessSessionConfiguration> CONFIGURATION_FIELD = SdkField
            .<CreateRemoteAccessSessionConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateRemoteAccessSessionRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(CreateRemoteAccessSessionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> INTERACTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRemoteAccessSessionRequest::interactionModeAsString)).setter(setter(Builder::interactionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interactionMode").build()).build();

    private static final SdkField<Boolean> SKIP_APP_RESIGN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateRemoteAccessSessionRequest::skipAppResign)).setter(setter(Builder::skipAppResign))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipAppResign").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            DEVICE_ARN_FIELD, INSTANCE_ARN_FIELD, SSH_PUBLIC_KEY_FIELD, REMOTE_DEBUG_ENABLED_FIELD, REMOTE_RECORD_ENABLED_FIELD,
            REMOTE_RECORD_APP_ARN_FIELD, NAME_FIELD, CLIENT_ID_FIELD, CONFIGURATION_FIELD, INTERACTION_MODE_FIELD,
            SKIP_APP_RESIGN_FIELD));

    private final String projectArn;

    private final String deviceArn;

    private final String instanceArn;

    private final String sshPublicKey;

    private final Boolean remoteDebugEnabled;

    private final Boolean remoteRecordEnabled;

    private final String remoteRecordAppArn;

    private final String name;

    private final String clientId;

    private final CreateRemoteAccessSessionConfiguration configuration;

    private final String interactionMode;

    private final Boolean skipAppResign;

    private CreateRemoteAccessSessionRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.deviceArn = builder.deviceArn;
        this.instanceArn = builder.instanceArn;
        this.sshPublicKey = builder.sshPublicKey;
        this.remoteDebugEnabled = builder.remoteDebugEnabled;
        this.remoteRecordEnabled = builder.remoteRecordEnabled;
        this.remoteRecordAppArn = builder.remoteRecordAppArn;
        this.name = builder.name;
        this.clientId = builder.clientId;
        this.configuration = builder.configuration;
        this.interactionMode = builder.interactionMode;
        this.skipAppResign = builder.skipAppResign;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.
     */
    public String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * The ARN of the device for which you want to create a remote access session.
     * </p>
     * 
     * @return The ARN of the device for which you want to create a remote access session.
     */
    public String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the device instance for which you want to create a remote access session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the device instance for which you want to create a remote access
     *         session.
     */
    public String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * Ignored. The public key of the <code>ssh</code> key pair you want to use for connecting to remote devices in your
     * remote debugging session. This key is required only if <code>remoteDebugEnabled</code> is set to
     * <code>true</code>.
     * </p>
     * <p>
     * Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
     * supported</a>.
     * </p>
     * 
     * @return Ignored. The public key of the <code>ssh</code> key pair you want to use for connecting to remote devices
     *         in your remote debugging session. This key is required only if <code>remoteDebugEnabled</code> is set to
     *         <code>true</code>.</p>
     *         <p>
     *         Remote debugging is <a
     *         href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.
     */
    public String sshPublicKey() {
        return sshPublicKey;
    }

    /**
     * <p>
     * Set to <code>true</code> if you want to access devices remotely for debugging in your remote access session.
     * </p>
     * <p>
     * Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
     * supported</a>.
     * </p>
     * 
     * @return Set to <code>true</code> if you want to access devices remotely for debugging in your remote access
     *         session.</p>
     *         <p>
     *         Remote debugging is <a
     *         href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.
     */
    public Boolean remoteDebugEnabled() {
        return remoteDebugEnabled;
    }

    /**
     * <p>
     * Set to <code>true</code> to enable remote recording for the remote access session.
     * </p>
     * 
     * @return Set to <code>true</code> to enable remote recording for the remote access session.
     */
    public Boolean remoteRecordEnabled() {
        return remoteRecordEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.
     */
    public String remoteRecordAppArn() {
        return remoteRecordAppArn;
    }

    /**
     * <p>
     * The name of the remote access session to create.
     * </p>
     * 
     * @return The name of the remote access session to create.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Unique identifier for the client. If you want access to multiple devices on the same client, you should pass the
     * same <code>clientId</code> value in each call to <code>CreateRemoteAccessSession</code>. This identifier is
     * required only if <code>remoteDebugEnabled</code> is set to <code>true</code>.
     * </p>
     * <p>
     * Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
     * supported</a>.
     * </p>
     * 
     * @return Unique identifier for the client. If you want access to multiple devices on the same client, you should
     *         pass the same <code>clientId</code> value in each call to <code>CreateRemoteAccessSession</code>. This
     *         identifier is required only if <code>remoteDebugEnabled</code> is set to <code>true</code>.</p>
     *         <p>
     *         Remote debugging is <a
     *         href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The configuration information for the remote access session request.
     * </p>
     * 
     * @return The configuration information for the remote access session request.
     */
    public CreateRemoteAccessSessionConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The interaction mode of the remote access session. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the screen. You cannot run
     * XCUITest framework-based tests in this mode.
     * </p>
     * </li>
     * <li>
     * <p>
     * NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This mode has the
     * fastest test execution speed. You can run XCUITest framework-based tests in this mode.
     * </p>
     * </li>
     * <li>
     * <p>
     * VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest framework-based tests
     * and watch the screen in this mode.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interactionMode}
     * will return {@link InteractionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interactionModeAsString}.
     * </p>
     * 
     * @return The interaction mode of the remote access session. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the screen. You
     *         cannot run XCUITest framework-based tests in this mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This mode has
     *         the fastest test execution speed. You can run XCUITest framework-based tests in this mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest framework-based
     *         tests and watch the screen in this mode.
     *         </p>
     *         </li>
     * @see InteractionMode
     */
    public InteractionMode interactionMode() {
        return InteractionMode.fromValue(interactionMode);
    }

    /**
     * <p>
     * The interaction mode of the remote access session. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the screen. You cannot run
     * XCUITest framework-based tests in this mode.
     * </p>
     * </li>
     * <li>
     * <p>
     * NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This mode has the
     * fastest test execution speed. You can run XCUITest framework-based tests in this mode.
     * </p>
     * </li>
     * <li>
     * <p>
     * VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest framework-based tests
     * and watch the screen in this mode.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interactionMode}
     * will return {@link InteractionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interactionModeAsString}.
     * </p>
     * 
     * @return The interaction mode of the remote access session. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the screen. You
     *         cannot run XCUITest framework-based tests in this mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This mode has
     *         the fastest test execution speed. You can run XCUITest framework-based tests in this mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest framework-based
     *         tests and watch the screen in this mode.
     *         </p>
     *         </li>
     * @see InteractionMode
     */
    public String interactionModeAsString() {
        return interactionMode;
    }

    /**
     * <p>
     * When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public devices,
     * Device Farm always signs your apps again.
     * </p>
     * <p>
     * For more information on how Device Farm modifies your uploads during tests, see <a
     * href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a>
     * </p>
     * 
     * @return When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
     *         devices, Device Farm always signs your apps again.</p>
     *         <p>
     *         For more information on how Device Farm modifies your uploads during tests, see <a
     *         href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a>
     */
    public Boolean skipAppResign() {
        return skipAppResign;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(remoteDebugEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(remoteRecordEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(remoteRecordAppArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(interactionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(skipAppResign());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRemoteAccessSessionRequest)) {
            return false;
        }
        CreateRemoteAccessSessionRequest other = (CreateRemoteAccessSessionRequest) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(deviceArn(), other.deviceArn())
                && Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(sshPublicKey(), other.sshPublicKey())
                && Objects.equals(remoteDebugEnabled(), other.remoteDebugEnabled())
                && Objects.equals(remoteRecordEnabled(), other.remoteRecordEnabled())
                && Objects.equals(remoteRecordAppArn(), other.remoteRecordAppArn()) && Objects.equals(name(), other.name())
                && Objects.equals(clientId(), other.clientId()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(interactionModeAsString(), other.interactionModeAsString())
                && Objects.equals(skipAppResign(), other.skipAppResign());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateRemoteAccessSessionRequest").add("ProjectArn", projectArn()).add("DeviceArn", deviceArn())
                .add("InstanceArn", instanceArn()).add("SshPublicKey", sshPublicKey())
                .add("RemoteDebugEnabled", remoteDebugEnabled()).add("RemoteRecordEnabled", remoteRecordEnabled())
                .add("RemoteRecordAppArn", remoteRecordAppArn()).add("Name", name()).add("ClientId", clientId())
                .add("Configuration", configuration()).add("InteractionMode", interactionModeAsString())
                .add("SkipAppResign", skipAppResign()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "deviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "instanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "sshPublicKey":
            return Optional.ofNullable(clazz.cast(sshPublicKey()));
        case "remoteDebugEnabled":
            return Optional.ofNullable(clazz.cast(remoteDebugEnabled()));
        case "remoteRecordEnabled":
            return Optional.ofNullable(clazz.cast(remoteRecordEnabled()));
        case "remoteRecordAppArn":
            return Optional.ofNullable(clazz.cast(remoteRecordAppArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "interactionMode":
            return Optional.ofNullable(clazz.cast(interactionModeAsString()));
        case "skipAppResign":
            return Optional.ofNullable(clazz.cast(skipAppResign()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRemoteAccessSessionRequest, T> g) {
        return obj -> g.apply((CreateRemoteAccessSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRemoteAccessSessionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.
         * </p>
         * 
         * @param projectArn
         *        The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * The ARN of the device for which you want to create a remote access session.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of the device for which you want to create a remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the device instance for which you want to create a remote access session.
         * </p>
         * 
         * @param instanceArn
         *        The Amazon Resource Name (ARN) of the device instance for which you want to create a remote access
         *        session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * Ignored. The public key of the <code>ssh</code> key pair you want to use for connecting to remote devices in
         * your remote debugging session. This key is required only if <code>remoteDebugEnabled</code> is set to
         * <code>true</code>.
         * </p>
         * <p>
         * Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
         * longer supported</a>.
         * </p>
         * 
         * @param sshPublicKey
         *        Ignored. The public key of the <code>ssh</code> key pair you want to use for connecting to remote
         *        devices in your remote debugging session. This key is required only if <code>remoteDebugEnabled</code>
         *        is set to <code>true</code>.</p>
         *        <p>
         *        Remote debugging is <a
         *        href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
         *        supported</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKey(String sshPublicKey);

        /**
         * <p>
         * Set to <code>true</code> if you want to access devices remotely for debugging in your remote access session.
         * </p>
         * <p>
         * Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
         * longer supported</a>.
         * </p>
         * 
         * @param remoteDebugEnabled
         *        Set to <code>true</code> if you want to access devices remotely for debugging in your remote access
         *        session.</p>
         *        <p>
         *        Remote debugging is <a
         *        href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
         *        supported</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteDebugEnabled(Boolean remoteDebugEnabled);

        /**
         * <p>
         * Set to <code>true</code> to enable remote recording for the remote access session.
         * </p>
         * 
         * @param remoteRecordEnabled
         *        Set to <code>true</code> to enable remote recording for the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteRecordEnabled(Boolean remoteRecordEnabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.
         * </p>
         * 
         * @param remoteRecordAppArn
         *        The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteRecordAppArn(String remoteRecordAppArn);

        /**
         * <p>
         * The name of the remote access session to create.
         * </p>
         * 
         * @param name
         *        The name of the remote access session to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Unique identifier for the client. If you want access to multiple devices on the same client, you should pass
         * the same <code>clientId</code> value in each call to <code>CreateRemoteAccessSession</code>. This identifier
         * is required only if <code>remoteDebugEnabled</code> is set to <code>true</code>.
         * </p>
         * <p>
         * Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
         * longer supported</a>.
         * </p>
         * 
         * @param clientId
         *        Unique identifier for the client. If you want access to multiple devices on the same client, you
         *        should pass the same <code>clientId</code> value in each call to
         *        <code>CreateRemoteAccessSession</code>. This identifier is required only if
         *        <code>remoteDebugEnabled</code> is set to <code>true</code>.</p>
         *        <p>
         *        Remote debugging is <a
         *        href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
         *        supported</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The configuration information for the remote access session request.
         * </p>
         * 
         * @param configuration
         *        The configuration information for the remote access session request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(CreateRemoteAccessSessionConfiguration configuration);

        /**
         * <p>
         * The configuration information for the remote access session request.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateRemoteAccessSessionConfiguration.Builder}
         * avoiding the need to create one manually via {@link CreateRemoteAccessSessionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateRemoteAccessSessionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(CreateRemoteAccessSessionConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link CreateRemoteAccessSessionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(CreateRemoteAccessSessionConfiguration)
         */
        default Builder configuration(Consumer<CreateRemoteAccessSessionConfiguration.Builder> configuration) {
            return configuration(CreateRemoteAccessSessionConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The interaction mode of the remote access session. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the screen. You cannot
         * run XCUITest framework-based tests in this mode.
         * </p>
         * </li>
         * <li>
         * <p>
         * NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This mode has the
         * fastest test execution speed. You can run XCUITest framework-based tests in this mode.
         * </p>
         * </li>
         * <li>
         * <p>
         * VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest framework-based
         * tests and watch the screen in this mode.
         * </p>
         * </li>
         * </ul>
         * 
         * @param interactionMode
         *        The interaction mode of the remote access session. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the screen. You
         *        cannot run XCUITest framework-based tests in this mode.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This mode
         *        has the fastest test execution speed. You can run XCUITest framework-based tests in this mode.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest
         *        framework-based tests and watch the screen in this mode.
         *        </p>
         *        </li>
         * @see InteractionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InteractionMode
         */
        Builder interactionMode(String interactionMode);

        /**
         * <p>
         * The interaction mode of the remote access session. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the screen. You cannot
         * run XCUITest framework-based tests in this mode.
         * </p>
         * </li>
         * <li>
         * <p>
         * NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This mode has the
         * fastest test execution speed. You can run XCUITest framework-based tests in this mode.
         * </p>
         * </li>
         * <li>
         * <p>
         * VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest framework-based
         * tests and watch the screen in this mode.
         * </p>
         * </li>
         * </ul>
         * 
         * @param interactionMode
         *        The interaction mode of the remote access session. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the screen. You
         *        cannot run XCUITest framework-based tests in this mode.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This mode
         *        has the fastest test execution speed. You can run XCUITest framework-based tests in this mode.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest
         *        framework-based tests and watch the screen in this mode.
         *        </p>
         *        </li>
         * @see InteractionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InteractionMode
         */
        Builder interactionMode(InteractionMode interactionMode);

        /**
         * <p>
         * When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
         * devices, Device Farm always signs your apps again.
         * </p>
         * <p>
         * For more information on how Device Farm modifies your uploads during tests, see <a
         * href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a>
         * </p>
         * 
         * @param skipAppResign
         *        When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For
         *        public devices, Device Farm always signs your apps again.</p>
         *        <p>
         *        For more information on how Device Farm modifies your uploads during tests, see <a
         *        href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipAppResign(Boolean skipAppResign);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String projectArn;

        private String deviceArn;

        private String instanceArn;

        private String sshPublicKey;

        private Boolean remoteDebugEnabled;

        private Boolean remoteRecordEnabled;

        private String remoteRecordAppArn;

        private String name;

        private String clientId;

        private CreateRemoteAccessSessionConfiguration configuration;

        private String interactionMode;

        private Boolean skipAppResign;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRemoteAccessSessionRequest model) {
            super(model);
            projectArn(model.projectArn);
            deviceArn(model.deviceArn);
            instanceArn(model.instanceArn);
            sshPublicKey(model.sshPublicKey);
            remoteDebugEnabled(model.remoteDebugEnabled);
            remoteRecordEnabled(model.remoteRecordEnabled);
            remoteRecordAppArn(model.remoteRecordAppArn);
            name(model.name);
            clientId(model.clientId);
            configuration(model.configuration);
            interactionMode(model.interactionMode);
            skipAppResign(model.skipAppResign);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        public final String getSshPublicKey() {
            return sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        public final Boolean getRemoteDebugEnabled() {
            return remoteDebugEnabled;
        }

        @Override
        public final Builder remoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
            return this;
        }

        public final void setRemoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
        }

        public final Boolean getRemoteRecordEnabled() {
            return remoteRecordEnabled;
        }

        @Override
        public final Builder remoteRecordEnabled(Boolean remoteRecordEnabled) {
            this.remoteRecordEnabled = remoteRecordEnabled;
            return this;
        }

        public final void setRemoteRecordEnabled(Boolean remoteRecordEnabled) {
            this.remoteRecordEnabled = remoteRecordEnabled;
        }

        public final String getRemoteRecordAppArn() {
            return remoteRecordAppArn;
        }

        @Override
        public final Builder remoteRecordAppArn(String remoteRecordAppArn) {
            this.remoteRecordAppArn = remoteRecordAppArn;
            return this;
        }

        public final void setRemoteRecordAppArn(String remoteRecordAppArn) {
            this.remoteRecordAppArn = remoteRecordAppArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final CreateRemoteAccessSessionConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(CreateRemoteAccessSessionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(CreateRemoteAccessSessionConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final String getInteractionModeAsString() {
            return interactionMode;
        }

        @Override
        public final Builder interactionMode(String interactionMode) {
            this.interactionMode = interactionMode;
            return this;
        }

        @Override
        public final Builder interactionMode(InteractionMode interactionMode) {
            this.interactionMode(interactionMode == null ? null : interactionMode.toString());
            return this;
        }

        public final void setInteractionMode(String interactionMode) {
            this.interactionMode = interactionMode;
        }

        public final Boolean getSkipAppResign() {
            return skipAppResign;
        }

        @Override
        public final Builder skipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
            return this;
        }

        public final void setSkipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRemoteAccessSessionRequest build() {
            return new CreateRemoteAccessSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
